/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.io.ChannelUtil;

public class HttpEntityWriter
implements Consumer<HttpEntity> {
    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        return HttpEntity.class.isAssignableFrom(mtype.asClass());
    }

    @Override
    public Fluid consume(final HttpEntity result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() throws IOException {
                if (result != null) {
                    EntityUtils.consume((HttpEntity)result);
                }
            }

            @Override
            protected String toHttpEntityMedia(FluidType media) {
                if (result == null) {
                    return ftype.as(media).preferred();
                }
                Header hd = result.getContentType();
                if (hd == null) {
                    return ftype.as(media).preferred();
                }
                return ftype.as(hd.getValue()).as(media).preferred();
            }

            @Override
            protected HttpEntity asHttpEntity(FluidType media) throws Exception {
                if (result == null) {
                    return null;
                }
                return result;
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                if (result == null) {
                    return ftype.as(media).preferred();
                }
                Header hd = result.getContentType();
                if (hd == null) {
                    return ftype.as(media).preferred();
                }
                return ftype.as(hd.getValue()).as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
                if (result == null) {
                    return null;
                }
                return ChannelUtil.newChannel(result.getContent());
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

