/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.io.CatReadableByteChannel;
import org.openrdf.http.object.io.ChannelUtil;
import org.xml.sax.SAXException;

public class HttpMessageWriter
implements Consumer<HttpMessage> {
    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        return HttpMessage.class.isAssignableFrom(mtype.asClass());
    }

    @Override
    public Fluid consume(final HttpMessage result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() throws IOException {
                HttpEntity entity = HttpMessageWriter.this.getEntity(result);
                if (entity != null) {
                    EntityUtils.consume((HttpEntity)entity);
                }
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return HttpMessageWriter.this.getMediaType(ftype.as(media));
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
                return HttpMessageWriter.this.write(ftype.as(this.toChannelMedia(media)), result, base);
            }

            @Override
            protected String toHttpResponseMedia(FluidType media) {
                if (result instanceof HttpResponse) {
                    return ftype.as(media).preferred();
                }
                return null;
            }

            @Override
            protected HttpResponse asHttpResponse(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException, SAXException {
                BasicHttpResponse resp = new BasicHttpResponse(((HttpResponse)result).getStatusLine());
                resp.setHeaders(result.getAllHeaders());
                resp.setEntity(((HttpResponse)result).getEntity());
                return resp;
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    String getMediaType(FluidType ftype) {
        return ftype.as("message/http", "application/http", "*/*").preferred();
    }

    ReadableByteChannel write(FluidType mtype, HttpMessage result, String base) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
        return this.serialize(result);
    }

    public ReadableByteChannel serialize(HttpMessage result) throws IOException {
        HttpEntity entity;
        if (result == null) {
            return null;
        }
        CatReadableByteChannel cat = new CatReadableByteChannel();
        if (result instanceof HttpResponse) {
            this.print(cat, ((HttpResponse)result).getStatusLine());
        } else if (result instanceof HttpRequest) {
            this.print(cat, ((HttpRequest)result).getRequestLine());
        }
        if (result != null) {
            for (Header hd : result.getAllHeaders()) {
                this.print(cat, hd);
            }
        }
        if ((entity = this.getEntity(result)) == null) {
            cat.println();
        } else {
            Header type = entity.getContentType();
            if (!result.containsHeader("Content-Type") && type != null) {
                this.print(cat, type);
            }
            Header encoding = entity.getContentEncoding();
            if (!result.containsHeader("Content-Encoding") && encoding != null) {
                this.print(cat, encoding);
            }
            long length = entity.getContentLength();
            if (!result.containsHeader("Content-Length") && length >= 0L) {
                this.print(cat, length);
            }
            ReadableByteChannel in = ChannelUtil.newChannel(entity.getContent());
            if (result.containsHeader("Content-Length") || length >= 0L) {
                cat.println();
                cat.append(in);
            } else if (result.containsHeader("Transfer-Encoding")) {
                cat.println();
                cat.append(in);
            } else {
                this.print(cat, (Header)new BasicHeader("Transfer-Encoding", "identity"));
                cat.println();
                cat.append(in);
            }
        }
        return cat;
    }

    HttpEntity getEntity(HttpMessage msg) {
        if (msg instanceof HttpResponse) {
            return ((HttpResponse)msg).getEntity();
        }
        if (msg instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)msg).getEntity();
        }
        return null;
    }

    private void print(CatReadableByteChannel cat, RequestLine line) throws IOException {
        cat.print(line.getMethod());
        cat.print(" ");
        cat.print(line.getUri());
        cat.print(" ");
        this.print(cat, line.getProtocolVersion());
        cat.println();
    }

    private void print(CatReadableByteChannel cat, StatusLine status) throws IOException {
        this.print(cat, status.getProtocolVersion());
        cat.print(" ");
        cat.print(Integer.toString(status.getStatusCode()));
        cat.print(" ");
        cat.println(status.getReasonPhrase());
    }

    private void print(CatReadableByteChannel cat, ProtocolVersion ver) throws IOException {
        cat.print(ver.getProtocol());
        cat.print("/");
        cat.print(Integer.toString(ver.getMajor()));
        cat.print(".");
        cat.print(Integer.toString(ver.getMinor()));
    }

    private void print(CatReadableByteChannel cat, Header hd) throws IOException {
        cat.print(hd.getName());
        cat.print(": ");
        cat.println(hd.getValue());
    }

    private void print(CatReadableByteChannel cat, long length) throws IOException {
        cat.print("Content-Length: ");
        cat.println(Long.toString(length));
    }
}

