/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.XMLEventReaderFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InputStreamBodyWriter
implements Consumer<InputStream> {
    private final DocumentFactory docFactory = DocumentFactory.newInstance();
    private final XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
    private final XMLEventReaderFactory inFactory = XMLEventReaderFactory.newInstance();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        return InputStream.class.isAssignableFrom(mtype.asClass());
    }

    @Override
    public Fluid consume(final InputStream result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() throws IOException {
                if (result != null) {
                    result.close();
                }
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException {
                return ChannelUtil.newChannel(result);
            }

            @Override
            protected String toStreamMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected InputStream asStream(FluidType media) {
                return result;
            }

            @Override
            protected String toReaderMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Reader asReader(FluidType media) throws IOException, XMLStreamException {
                FluidType ctype = ftype.as(media);
                if (!ctype.isXML()) {
                    Charset charset = ctype.getCharset();
                    if (charset == null) {
                        charset = Charset.defaultCharset();
                    }
                    return new InputStreamReader(result, charset);
                }
                CharArrayWriter caw = new CharArrayWriter(8192);
                try {
                    this.writeTo((Writer)caw, media);
                }
                finally {
                    caw.close();
                }
                return new CharArrayReader(caw.toCharArray());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void writeTo(Writer writer, FluidType media) throws IOException, XMLStreamException {
                if (!ftype.as(media).isXML()) {
                    Reader reader = this.asReader(media);
                    if (reader == null) {
                        return;
                    }
                    try {
                        int read;
                        char[] cbuf = new char[1024];
                        while ((read = reader.read(cbuf)) >= 0) {
                            writer.write(cbuf, 0, read);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                XMLEventReader reader = this.asXMLEventReader(media);
                if (reader == null) {
                    return;
                }
                try {
                    XMLEventWriter xml = InputStreamBodyWriter.this.outFactory.createXMLEventWriter(writer);
                    xml.add(reader);
                    xml.flush();
                }
                finally {
                    reader.close();
                }
            }

            @Override
            protected String toXMLEventReaderMedia(FluidType media) {
                return ftype.asXML().as(media).preferred();
            }

            @Override
            protected XMLEventReader asXMLEventReader(FluidType media) throws XMLStreamException {
                InputStream in = this.asStream(media);
                if (in == null) {
                    return null;
                }
                if (base == null) {
                    return InputStreamBodyWriter.this.inFactory.createXMLEventReader(in);
                }
                return InputStreamBodyWriter.this.inFactory.createXMLEventReader(base, in);
            }

            @Override
            protected String toDocumentMedia(FluidType media) {
                return ftype.asXML().as(media).preferred();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Document asDocument(FluidType media) throws SAXException, IOException, ParserConfigurationException {
                InputStream in = this.asStream(media);
                if (in == null) {
                    return null;
                }
                try {
                    if (base == null) {
                        Document document = InputStreamBodyWriter.this.docFactory.parse(in);
                        return document;
                    }
                    Document document = InputStreamBodyWriter.this.docFactory.parse(in, base);
                    return document;
                }
                finally {
                    in.close();
                }
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

