/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Set;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.consumers.GraphMessageWriter;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.impl.GraphQueryResultImpl;

public class ModelMessageWriter
implements Consumer<Model> {
    private GraphMessageWriter delegate = new GraphMessageWriter();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        if (!Model.class.isAssignableFrom(mtype.asClass())) {
            return false;
        }
        return this.delegate.isConsumable(mtype.as((Type)((Object)GraphQueryResult.class)), builder);
    }

    @Override
    public Fluid consume(Model model, String base, FluidType ftype, FluidBuilder builder) {
        GraphQueryResultImpl result = null;
        if (model != null) {
            Set namespaces = model.getNamespaces();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(namespaces.size());
            for (Namespace ns : namespaces) {
                map.put(ns.getPrefix(), ns.getName());
            }
            result = new GraphQueryResultImpl(map, (Iterable)model);
        }
        return this.delegate.consume(result, base, ftype.as((Type)((Object)GraphQueryResult.class)), builder);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

