/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.lang.reflect.Type;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;

public class PrimitiveBodyWriter
implements Consumer<Object> {
    @Override
    public boolean isConsumable(FluidType ftype, FluidBuilder builder) {
        return this.isPrimitive(ftype.asClass()) && ftype.is("text/*");
    }

    @Override
    public Fluid consume(Object result, String base, FluidType ftype, FluidBuilder builder) {
        String str = null;
        if (result == null && ftype.is(Boolean.TYPE)) {
            str = "false";
        } else if (result == null && ftype.isPrimitive()) {
            str = "0";
        } else if (result != null) {
            str = result.toString();
        }
        return builder.consume(str, base, ftype.as((Type)((Object)String.class)));
    }

    private boolean isPrimitive(Class<?> asClass) {
        return asClass.isPrimitive() || this.isPrimitiveWrapper(asClass);
    }

    private boolean isPrimitiveWrapper(Class<?> asClass) {
        if (Boolean.class.equals(asClass)) {
            return true;
        }
        if (Byte.class.equals(asClass)) {
            return true;
        }
        if (Short.class.equals(asClass)) {
            return true;
        }
        if (Character.class.equals(asClass)) {
            return true;
        }
        if (Integer.class.equals(asClass)) {
            return true;
        }
        if (Long.class.equals(asClass)) {
            return true;
        }
        if (Float.class.equals(asClass)) {
            return true;
        }
        return Double.class.equals(asClass);
    }
}

