/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.ProducerStream;
import org.openrdf.http.object.io.XMLEventReaderFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ReadableBodyWriter
implements Consumer<Readable> {
    private final DocumentFactory docFactory = DocumentFactory.newInstance();
    private final XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
    private final XMLEventReaderFactory inFactory = XMLEventReaderFactory.newInstance();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        if (!Readable.class.isAssignableFrom(mtype.asClass())) {
            return false;
        }
        return mtype.is("text/*");
    }

    @Override
    public Fluid consume(final Readable result, final String base, FluidType type, FluidBuilder builder) {
        final FluidType ftype = type.as("text/plain", "text/*");
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() throws IOException {
                if (result instanceof Closeable) {
                    ((Closeable)((Object)result)).close();
                }
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return this.toStreamMedia(media);
            }

            @Override
            protected ReadableByteChannel asChannel(final FluidType media) throws IOException {
                if (result == null) {
                    return null;
                }
                return ChannelUtil.newChannel(new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, media);
                        }
                        catch (XMLStreamException e) {
                            throw new IOException(e);
                        }
                    }

                    public String toString() {
                        return String.valueOf(result);
                    }
                }));
            }

            @Override
            protected String toStreamMedia(FluidType media) {
                FluidType ctype = ftype.as(media);
                String mimeType = ctype.preferred();
                Charset charset = ctype.getCharset();
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                if (mimeType == null || mimeType.contains("charset=")) {
                    return mimeType;
                }
                return mimeType + ";charset=" + charset.name();
            }

            @Override
            protected InputStream asStream(final FluidType media) throws IOException {
                if (result == null) {
                    return null;
                }
                return new ProducerStream(new ProducerStream.OutputProducer(){

                    @Override
                    public void produce(OutputStream out) throws IOException {
                        try {
                            this.streamTo(out, media);
                        }
                        catch (XMLStreamException e) {
                            throw new IOException(e);
                        }
                    }

                    public String toString() {
                        return String.valueOf(result);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void streamTo(OutputStream out, FluidType media) throws IOException, XMLStreamException {
                block12: {
                    if (result == null) {
                        return;
                    }
                    try {
                        FluidType ctype = ftype.as(media);
                        Charset charset = ctype.getCharset();
                        if (charset == null) {
                            charset = Charset.defaultCharset();
                        }
                        if (!ctype.isXML() || ctype.is("text/*")) {
                            OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                            CharBuffer cb = CharBuffer.allocate(1024);
                            while (result.read(cb) >= 0) {
                                cb.flip();
                                ((Writer)writer).write(cb.array(), cb.position(), cb.limit());
                                cb.clear();
                            }
                            ((Writer)writer).flush();
                            break block12;
                        }
                        XMLEventReader reader = this.asXMLEventReader(media);
                        if (reader == null) {
                            return;
                        }
                        try {
                            XMLEventWriter writer = ReadableBodyWriter.this.outFactory.createXMLEventWriter(out, charset.name());
                            writer.add(reader);
                            writer.flush();
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        this.asVoid();
                    }
                }
            }

            @Override
            protected String toCharSequenceMedia(FluidType media) {
                return ftype.as("text/plain", "text/*").as(media).preferred();
            }

            @Override
            protected CharSequence asCharSequence(FluidType media) throws IOException {
                if (result == null) {
                    return null;
                }
                StringWriter output = new StringWriter();
                this.writeTo((Writer)output, media);
                return output.getBuffer();
            }

            @Override
            protected String toReaderMedia(FluidType media) {
                return ftype.as("text/plain", "text/*").as(media).preferred();
            }

            @Override
            protected Reader asReader(FluidType media) {
                if (result == null) {
                    return null;
                }
                if (result instanceof Reader) {
                    return (Reader)result;
                }
                return new Reader(){

                    @Override
                    public void close() throws IOException {
                        this.asVoid();
                    }

                    @Override
                    public int read(char[] cbuf, int off, int len) throws IOException {
                        return result.read(CharBuffer.wrap(cbuf, off, len));
                    }

                    @Override
                    public int read(CharBuffer cbuf) throws IOException {
                        return result.read(cbuf);
                    }

                    public String toString() {
                        return String.valueOf(result);
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void writeTo(Writer writer, FluidType media) throws IOException {
                Reader reader = this.asReader(media);
                if (reader == null) {
                    return;
                }
                try {
                    int read;
                    char[] cbuf = new char[1024];
                    while ((read = reader.read(cbuf)) >= 0) {
                        writer.write(cbuf, 0, read);
                    }
                }
                finally {
                    reader.close();
                }
            }

            @Override
            protected String toXMLEventReaderMedia(FluidType media) {
                return ftype.asXML().as(media).preferred();
            }

            @Override
            protected XMLEventReader asXMLEventReader(FluidType media) throws XMLStreamException {
                Reader source = this.asReader(media);
                if (source == null) {
                    return null;
                }
                if (base == null) {
                    return ReadableBodyWriter.this.inFactory.createXMLEventReader(source);
                }
                return ReadableBodyWriter.this.inFactory.createXMLEventReader(base, source);
            }

            @Override
            protected String toDocumentMedia(FluidType media) {
                return this.toXMLEventReaderMedia(media);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Document asDocument(FluidType media) throws SAXException, IOException, ParserConfigurationException {
                Reader reader = this.asReader(media);
                if (reader == null) {
                    return null;
                }
                try {
                    if (base == null) {
                        Document document = ReadableBodyWriter.this.docFactory.parse(reader);
                        return document;
                    }
                    Document document = ReadableBodyWriter.this.docFactory.parse(reader, base);
                    return document;
                }
                finally {
                    this.asVoid();
                }
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

