/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;

public class ReadableByteChannelBodyWriter
implements Consumer<ReadableByteChannel> {
    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        return ReadableByteChannel.class.isAssignableFrom(mtype.asClass());
    }

    @Override
    public Fluid consume(final ReadableByteChannel result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() throws IOException {
                if (result != null) {
                    result.close();
                }
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
                return result;
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }
}

