/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.http.HttpEntity;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.helpers.CharSequenceReader;
import org.openrdf.http.object.helpers.ReadableHttpEntityChannel;
import org.openrdf.http.object.io.ChannelUtil;
import org.xml.sax.SAXException;

public class StringBodyWriter
implements Consumer<CharSequence> {
    static final boolean SINGLE_BYTE = 1.0f == Charset.defaultCharset().newEncoder().maxBytesPerChar();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        if (!mtype.is("text/*")) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(mtype.asClass());
    }

    @Override
    public Fluid consume(final CharSequence result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return StringBodyWriter.this.getMediaType(ftype.as(media));
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException {
                return StringBodyWriter.this.write(ftype.as(this.toChannelMedia(media)), result, base);
            }

            @Override
            protected String toHttpEntityMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected HttpEntity asHttpEntity(FluidType media) throws IOException {
                String mediaType = this.toChannelMedia(media);
                return new ReadableHttpEntityChannel(mediaType, StringBodyWriter.this.getSize(result, ftype.as(mediaType).getCharset()), this.asChannel(media));
            }

            @Override
            protected String toCharSequenceMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected CharSequence asCharSequence(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                return result;
            }

            @Override
            protected String toReaderMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected Reader asReader(FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                return new CharSequenceReader(result);
            }

            @Override
            protected void writeTo(Writer writer, FluidType media) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
                writer.append(result);
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    String getMediaType(FluidType ftype) {
        String mimeType = (ftype = ftype.as("text/plain", "text/*")).preferred();
        if (mimeType == null) {
            return mimeType;
        }
        Charset charset = ftype.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (mimeType.contains("charset=")) {
            return mimeType;
        }
        return mimeType + ";charset=" + charset.name();
    }

    long getSize(CharSequence result, Charset charset) {
        if (result == null) {
            return 0L;
        }
        if (charset == null && SINGLE_BYTE) {
            return result.length();
        }
        if (charset == null) {
            return Charset.defaultCharset().encode(result.toString()).limit();
        }
        return charset.encode(result.toString()).limit();
    }

    ReadableByteChannel write(FluidType mtype, CharSequence result, String base) throws IOException {
        Charset charset = mtype.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        if (result == null) {
            return ChannelUtil.newChannel(new byte[0]);
        }
        return ChannelUtil.newChannel(result.toString().getBytes(charset));
    }
}

