/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.consumers.StringBodyWriter;
import org.openrdf.http.object.helpers.ReadableHttpEntityChannel;
import org.openrdf.http.object.io.ChannelUtil;

public abstract class URIListWriter<URI>
implements Consumer<URI> {
    private static final Charset USASCII = Charset.forName("US-ASCII");
    private StringBodyWriter delegate = new StringBodyWriter();
    private Class<URI> componentType;
    public static URIListWriter<org.openrdf.model.URI> RDF_URI = new URIListWriter<org.openrdf.model.URI>(org.openrdf.model.URI.class){

        @Override
        protected String toString(org.openrdf.model.URI result) {
            return result.stringValue();
        }
    };
    public static URIListWriter<URL> NET_URL = new URIListWriter<URL>(URL.class){

        @Override
        protected String toString(URL result) {
            return result.toExternalForm();
        }
    };
    public static URIListWriter<URI> NET_URI = new URIListWriter<URI>(URI.class){

        @Override
        protected String toString(URI result) {
            return result.toASCIIString();
        }
    };

    public URIListWriter(Class<URI> componentType) {
        this.componentType = componentType;
    }

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        Class<?> ctype = mtype.asClass();
        if (this.componentType != null) {
            if (!this.componentType.equals(ctype) && Object.class.equals(ctype)) {
                return false;
            }
            if (mtype.isSetOrArray()) {
                Class<?> component = mtype.component().asClass();
                if (!this.componentType.equals(component) && Object.class.equals(component)) {
                    return false;
                }
                if (!this.componentType.isAssignableFrom(component) && !component.equals(Object.class)) {
                    return false;
                }
            } else if (!this.componentType.isAssignableFrom(ctype)) {
                return false;
            }
        }
        return mtype.is("text/uri-list");
    }

    @Override
    public Fluid consume(final URI result, final String base, final FluidType ftype, FluidBuilder builder) {
        if (result == null) {
            return this.delegate.consume(null, base, ftype.as((Type)((Object)String.class)), builder);
        }
        if (!ftype.isSetOrArray()) {
            return this.delegate.consume(this.toString(result), base, ftype.as((Type)((Object)String.class)), builder);
        }
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                return URIListWriter.this.getMediaType(ftype.as(media));
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException {
                return ChannelUtil.newChannel(URIListWriter.this.write(ftype.as(this.toChannelMedia(media)), result, base));
            }

            @Override
            protected String toHttpEntityMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected HttpEntity asHttpEntity(FluidType media) throws IOException {
                String mediaType = this.toChannelMedia(media);
                int size = URIListWriter.this.write(ftype.as(mediaType), result, base).length;
                return new ReadableHttpEntityChannel(mediaType, size, this.asChannel(media));
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    String getMediaType(FluidType ftype) {
        String mimeType = ftype.as("text/uri-list", "text/*").preferred();
        if (mimeType == null || mimeType.contains("charset=")) {
            return mimeType;
        }
        return mimeType + ";charset=" + Charset.defaultCharset().name();
    }

    byte[] write(FluidType mtype, URI result, String base) throws IOException {
        if (result == null) {
            return null;
        }
        Charset charset = mtype.getCharset();
        if (charset == null) {
            charset = USASCII;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
        Iterator<?> iter = mtype.iteratorOf(result);
        while (iter.hasNext()) {
            writer.write(this.toString(this.componentType.cast(iter.next())));
            if (!iter.hasNext()) continue;
            writer.write("\r\n");
        }
        ((Writer)writer).flush();
        if (out.size() == 0) {
            return null;
        }
        return out.toByteArray();
    }

    protected abstract String toString(URI var1);
}

