/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.consumers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.ProducerStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLEventMessageWriter
implements Consumer<XMLEventReader> {
    final DocumentFactory docFactory = DocumentFactory.newInstance();
    XMLOutputFactory factory = XMLOutputFactory.newInstance();

    @Override
    public boolean isConsumable(FluidType mtype, FluidBuilder builder) {
        if (!XMLEventReader.class.isAssignableFrom(mtype.asClass())) {
            return false;
        }
        return mtype.is("application/*", "text/*", "image/xml");
    }

    @Override
    public Fluid consume(final XMLEventReader result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() {
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                FluidType ctype = ftype.as(media);
                String mimeType = ctype.preferred();
                if (mimeType != null && mimeType.startsWith("text/") && !mimeType.contains("charset=")) {
                    Charset charset = ctype.getCharset();
                    if (charset == null) {
                        charset = Charset.defaultCharset();
                    }
                    return mimeType + ";charset=" + charset.name();
                }
                return mimeType;
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException {
                return XMLEventMessageWriter.this.write(ftype.as(this.toChannelMedia(media)), result, base);
            }

            @Override
            protected String toStreamMedia(FluidType media) {
                return this.toChannelMedia(media);
            }

            @Override
            protected InputStream asStream(FluidType media) throws IOException, XMLStreamException {
                if (result == null) {
                    return null;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                try {
                    this.streamTo((OutputStream)baos, media);
                }
                finally {
                    baos.close();
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void streamTo(OutputStream out, FluidType media) throws XMLStreamException {
                XMLEventReader reader;
                FluidType ctype = ftype.as(media);
                Charset charset = ctype.getCharset();
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                if ((reader = this.asXMLEventReader(media)) == null) {
                    return;
                }
                try {
                    XMLEventWriter writer = XMLEventMessageWriter.this.factory.createXMLEventWriter(out, charset.name());
                    writer.add(reader);
                    writer.flush();
                }
                finally {
                    reader.close();
                }
            }

            @Override
            protected String toReaderMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected Reader asReader(FluidType media) throws XMLStreamException {
                if (result == null) {
                    return null;
                }
                CharArrayWriter caw = new CharArrayWriter(8192);
                try {
                    this.writeTo((Writer)caw, media);
                }
                finally {
                    caw.close();
                }
                return new CharArrayReader(caw.toCharArray());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void writeTo(Writer writer, FluidType media) throws XMLStreamException {
                XMLEventReader reader = this.asXMLEventReader(media);
                if (reader == null) {
                    return;
                }
                try {
                    XMLEventWriter xml = XMLEventMessageWriter.this.factory.createXMLEventWriter(writer);
                    xml.add(reader);
                    xml.flush();
                }
                finally {
                    reader.close();
                }
            }

            @Override
            protected String toXMLEventReaderMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            @Override
            protected XMLEventReader asXMLEventReader(FluidType media) {
                return result;
            }

            @Override
            protected String toDocumentMedia(FluidType media) {
                return ftype.as(media).preferred();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Document asDocument(FluidType media) throws IOException, SAXException, ParserConfigurationException, XMLStreamException {
                InputStream in = this.asStream(media);
                if (in == null) {
                    return null;
                }
                try {
                    if (base == null) {
                        Document document = XMLEventMessageWriter.this.docFactory.parse(in);
                        return document;
                    }
                    Document document = XMLEventMessageWriter.this.docFactory.parse(in, base);
                    return document;
                }
                finally {
                    in.close();
                }
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    ReadableByteChannel write(final FluidType mtype, final XMLEventReader result, final String base) throws IOException {
        if (result == null) {
            return null;
        }
        return ChannelUtil.newChannel(new ProducerStream(new ProducerStream.OutputProducer(){

            @Override
            public void produce(OutputStream out) throws IOException {
                try {
                    XMLEventMessageWriter.this.writeTo(mtype, result, base, out, 1024);
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
                finally {
                    out.close();
                }
            }

            public String toString() {
                return result.toString();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(FluidType mtype, XMLEventReader result, String base, OutputStream out, int bufSize) throws IOException, XMLStreamException {
        try {
            Charset charset = mtype.getCharset();
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            XMLEventWriter writer = this.factory.createXMLEventWriter(out, charset.name());
            try {
                writer.add(result);
                writer.flush();
            }
            finally {
                writer.close();
            }
        }
        finally {
            result.close();
        }
    }
}

