/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.helpers;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class CharSequenceReader
extends Reader {
    protected CharBuffer buf;

    public CharSequenceReader(CharSequence buf) {
        super(buf);
        this.buf = CharBuffer.wrap(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.buf = null;
            }
        }
    }

    private boolean isOpen() {
        return this.buf != null;
    }

    private boolean isClosed() {
        return this.buf == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Reader already closed");
            }
            this.buf.mark();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Reader already closed");
            }
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int len) throws IOException {
        if (offset < 0 || offset > buffer.length || len < 0 || len > buffer.length - offset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Reader already closed");
            }
            if (this.buf.hasRemaining()) {
                int bytesRead = len > this.buf.remaining() ? this.buf.remaining() : len;
                this.buf.get(buffer, offset, bytesRead);
                return bytesRead;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Reader already closed");
            }
            return this.buf.hasRemaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Reader already closed");
            }
            this.buf.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Reader already closed");
            }
            if (n <= 0L) {
                return 0L;
            }
            long skipped = 0L;
            if (n < (long)(this.buf.limit() - this.buf.position())) {
                this.buf.position(this.buf.position() + (int)n);
                skipped = n;
            } else {
                skipped = this.buf.limit() - this.buf.position();
                this.buf.position(this.buf.limit());
            }
            return skipped;
        }
    }
}

