/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.helpers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentFactory {
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final Logger logger = LoggerFactory.getLogger(DocumentFactory.class);
    private final DocumentBuilderFactory factory;

    public static DocumentFactory newInstance() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(false);
        try {
            factory.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (ParserConfigurationException e) {
            logger.warn(e.toString(), (Throwable)e);
        }
        return new DocumentFactory(factory);
    }

    protected DocumentFactory(DocumentBuilderFactory builder) {
        this.factory = builder;
    }

    public Document newDocument() throws ParserConfigurationException {
        return this.factory.newDocumentBuilder().newDocument();
    }

    public Document parse(InputStream in, String systemId) throws SAXException, IOException, ParserConfigurationException {
        if ((in = this.checkForVoidXML(in)) == null) {
            return null;
        }
        return this.factory.newDocumentBuilder().parse(in, systemId);
    }

    public Document parse(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        if ((in = this.checkForVoidXML(in)) == null) {
            return null;
        }
        return this.factory.newDocumentBuilder().parse(in);
    }

    public Document parse(Reader reader, String systemId) throws SAXException, IOException, ParserConfigurationException {
        if ((reader = this.checkForVoidXML(reader)) == null) {
            return null;
        }
        InputSource is = new InputSource(reader);
        is.setSystemId(systemId);
        return this.factory.newDocumentBuilder().parse(is);
    }

    public Document parse(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        if ((reader = this.checkForVoidXML(reader)) == null) {
            return null;
        }
        return this.factory.newDocumentBuilder().parse(new InputSource(reader));
    }

    private Reader checkForVoidXML(Reader reader) throws IOException {
        int read;
        if (reader == null) {
            return null;
        }
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        CharBuffer cbuf = CharBuffer.allocate(100);
        reader.mark(cbuf.limit());
        while (cbuf.hasRemaining() && (read = reader.read(cbuf)) >= 0) {
        }
        if (cbuf.hasRemaining() && this.isEmpty(cbuf.flip().toString())) {
            reader.close();
            return null;
        }
        reader.reset();
        return reader;
    }

    private InputStream checkForVoidXML(InputStream input) throws IOException {
        int read;
        if (input == null) {
            return null;
        }
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        ByteBuffer buf = ByteBuffer.allocate(200);
        input.mark(buf.limit());
        while (buf.hasRemaining() && (read = input.read(buf.array(), buf.position(), buf.remaining())) >= 0) {
            buf.position(buf.position() + read);
        }
        if (buf.hasRemaining() && this.isEmpty(buf.array(), buf.position())) {
            input.close();
            return null;
        }
        input.reset();
        return input;
    }

    private boolean isEmpty(byte[] buf, int len) {
        if (len == 0) {
            return true;
        }
        String xml = this.decodeXML(buf, len);
        if (xml == null) {
            return false;
        }
        return this.isEmpty(xml);
    }

    private boolean isEmpty(String xml) {
        if (xml == null || xml.length() < 1 || xml.trim().length() < 1) {
            return true;
        }
        if (xml.length() < 2) {
            return false;
        }
        if (xml.charAt(0) != '<' || xml.charAt(1) != '?') {
            return false;
        }
        if (xml.charAt(xml.length() - 2) != '?' || xml.charAt(xml.length() - 1) != '>') {
            return false;
        }
        int n = xml.length() - 2;
        for (int i = 1; i < n; ++i) {
            if (xml.charAt(i) != '<') continue;
            return false;
        }
        return true;
    }

    private String decodeXML(byte[] buf, int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)buf[i]);
        }
        String s = sb.toString();
        String APPFcharset = null;
        int byteOrderMark = 0;
        if (s.startsWith("\u00fe\u00ff")) {
            APPFcharset = "UTF-16BE";
            byteOrderMark = 2;
        } else if (s.startsWith("\u00ff\u00fe")) {
            APPFcharset = "UTF-16LE";
            byteOrderMark = 2;
        } else if (s.startsWith("\u00ef\u00bb\u00bf")) {
            APPFcharset = "UTF-8";
            byteOrderMark = 3;
        } else if (s.startsWith("\u0000<")) {
            APPFcharset = "UTF-16BE";
        } else if (s.startsWith("<\u0000")) {
            APPFcharset = "UTF-16LE";
        } else if (s.startsWith("<")) {
            APPFcharset = "US-ASCII";
        } else if (s.startsWith("Lo\u00a7\u0094")) {
            APPFcharset = "CP037";
        } else {
            return null;
        }
        try {
            byte[] bytes = s.substring(byteOrderMark).getBytes("iso-8859-1");
            String xml = new String(bytes, APPFcharset);
            if (xml.startsWith("<")) {
                return xml;
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

