/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.helpers;

import info.aduna.lang.FileFormat;
import info.aduna.lang.service.FileFormatServiceRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.Consumer;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Vapor;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.ProducerStream;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageWriterBase<FF extends FileFormat, S, T>
implements Consumer<T> {
    final Logger logger = LoggerFactory.getLogger(MessageWriterBase.class);
    private final FileFormatServiceRegistry<FF, S> registry;
    final String[] mimeTypes;
    private final Class<T> type;

    public MessageWriterBase(FileFormatServiceRegistry<FF, S> registry, Class<T> type) {
        this.registry = registry;
        this.type = type;
        LinkedHashSet set = new LinkedHashSet();
        for (FileFormat format : registry.getKeys()) {
            set.addAll(format.getMIMETypes());
        }
        this.mimeTypes = set.toArray(new String[set.size()]);
    }

    @Override
    public boolean isConsumable(FluidType ftype, FluidBuilder builder) {
        if (!this.isAssignableFrom(ftype.asClass())) {
            return false;
        }
        FluidType possible = new FluidType(ftype.asType(), this.mimeTypes).as(ftype);
        return this.getFactory(possible.preferred()) != null;
    }

    @Override
    public Fluid consume(final T result, final String base, final FluidType ftype, FluidBuilder builder) {
        return new Vapor(){

            @Override
            public String getSystemId() {
                return base;
            }

            @Override
            public FluidType getFluidType() {
                return ftype;
            }

            @Override
            public void asVoid() throws FluidException {
                if (result != null) {
                    try {
                        MessageWriterBase.this.close(result);
                    }
                    catch (OpenRDFException e) {
                        throw new FluidException(e);
                    }
                }
            }

            @Override
            protected String toChannelMedia(FluidType media) {
                FluidType possible = new FluidType(ftype.asType(), MessageWriterBase.this.mimeTypes).as(ftype).as(media);
                String contentType = possible.preferred();
                if (contentType == null) {
                    return null;
                }
                Object format = MessageWriterBase.this.getFormat(contentType);
                if (format.hasCharset() && contentType.startsWith("text/") && !contentType.contains("charset=")) {
                    Charset charset = possible.getCharset();
                    charset = MessageWriterBase.this.getCharset(format, charset);
                    contentType = contentType + ";charset=" + charset.name();
                }
                return contentType;
            }

            @Override
            protected ReadableByteChannel asChannel(FluidType media) throws IOException, OpenRDFException, XMLStreamException, TransformerException, ParserConfigurationException {
                return MessageWriterBase.this.write(ftype.as(this.toChannelMedia(media)), result, base);
            }

            @Override
            public String toString() {
                return String.valueOf(result);
            }
        };
    }

    protected boolean isAssignableFrom(Class<?> type) {
        return this.type.isAssignableFrom(type);
    }

    protected void close(T result) throws OpenRDFException {
    }

    final ReadableByteChannel write(final FluidType mtype, final T result, final String base) throws IOException {
        return ChannelUtil.newChannel(new ProducerStream(new ProducerStream.OutputProducer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void produce(OutputStream out) throws IOException {
                try {
                    MessageWriterBase.this.writeTo(mtype, result, base, out, 1024);
                    return;
                }
                catch (OpenRDFException e) {
                    throw new IOException(e);
                }
                finally {
                    try {
                        if (result != null) {
                            MessageWriterBase.this.close(result);
                        }
                    }
                    catch (OpenRDFException e) {
                        MessageWriterBase.this.logger.error(e.toString(), (Throwable)e);
                    }
                    finally {
                        out.close();
                    }
                }
            }

            public String toString() {
                return String.valueOf(result);
            }
        }));
    }

    void writeTo(FluidType mtype, T result, String base, OutputStream out, int bufSize) throws IOException, OpenRDFException {
        Charset charset = mtype.getCharset();
        String mimeType = mtype.preferred();
        FF format = this.getFormat(mimeType);
        if (charset == null && format.hasCharset()) {
            charset = this.getCharset(format, charset);
        }
        try {
            this.writeTo(this.getFactory(mimeType), result, out, charset, base);
        }
        catch (RDFHandlerException e) {
            Throwable cause = e.getCause();
            try {
                if (cause != null) {
                    throw cause;
                }
            }
            catch (IOException c) {
                throw c;
            }
            catch (OpenRDFException c) {
                throw c;
            }
            catch (Throwable c) {
                throw e;
            }
        }
        catch (TupleQueryResultHandlerException e) {
            Throwable cause = e.getCause();
            try {
                if (cause != null) {
                    throw cause;
                }
            }
            catch (IOException c) {
                throw c;
            }
            catch (OpenRDFException c) {
                throw c;
            }
            catch (Throwable c) {
                throw e;
            }
        }
    }

    protected Charset getCharset(FF format, Charset charset) {
        if (charset == null) {
            charset = format.getCharset();
        }
        return charset;
    }

    protected abstract void writeTo(S var1, T var2, OutputStream var3, Charset var4, String var5) throws IOException, RDFHandlerException, QueryEvaluationException, TupleQueryResultHandlerException;

    protected S getFactory(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        FF format = this.getFormat(mimeType);
        if (format == null) {
            return null;
        }
        return (S)this.registry.get(format);
    }

    protected FF getFormat(String mimeType) {
        if (mimeType == null || mimeType.contains("*") || "application/octet-stream".equals(mimeType)) {
            for (FileFormat format : this.registry.getKeys()) {
                if (this.registry.get((Object)format) == null) continue;
                return (FF)format;
            }
            return null;
        }
        int idx = mimeType.indexOf(59);
        if (idx > 0) {
            mimeType = mimeType.substring(0, idx);
        }
        return (FF)this.registry.getFileFormatForMIMEType(mimeType);
    }
}

