/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;

public class BufferedImageReader
implements Producer {
    private static final String[] READER_MIME_TYPES = ImageIO.getReaderMIMETypes();

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        return ftype.asClass().isAssignableFrom(BufferedImage.class) && ftype.is(READER_MIME_TYPES);
    }

    @Override
    public BufferedImage produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws Exception {
        if (in == null) {
            return null;
        }
        InputStream stream = ChannelUtil.newInputStream(in);
        return ImageIO.read(stream);
    }
}

