/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;

public class ByteArrayStreamMessageReader
implements Producer {
    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        return ftype.asClass().equals(ByteArrayOutputStream.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteArrayOutputStream produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws IOException {
        if (in == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            ChannelUtil.transfer(in, (OutputStream)out);
            ByteArrayOutputStream byteArrayOutputStream = out;
            return byteArrayOutputStream;
        }
        finally {
            in.close();
        }
    }
}

