/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMMessageReader
implements Producer {
    private DocumentFactory builder = DocumentFactory.newInstance();

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<Node> type = ftype.asClass();
        if (!ftype.isXML()) {
            return false;
        }
        return type.isAssignableFrom(Document.class) || type.isAssignableFrom(Element.class);
    }

    @Override
    public Node produce(FluidType ftype, ReadableByteChannel cin, Charset charset, String base, FluidBuilder builder) throws TransformerConfigurationException, TransformerException, ParserConfigurationException, IOException, SAXException {
        InputStream in = ChannelUtil.newInputStream(cin);
        Document doc = this.createDocument(in, charset);
        if (doc == null || ftype.asClass().isAssignableFrom(Document.class)) {
            return doc;
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(InputStream in, Charset charset) throws ParserConfigurationException, SAXException, IOException {
        try {
            if (in == null) {
                Document document = null;
                return document;
            }
            if (charset == null) {
                Document document = this.builder.parse(in);
                return document;
            }
            Document document = this.builder.parse(new InputStreamReader(in, charset));
            return document;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

