/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Set;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.fluid.producers.StringBodyReader;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectFactory;
import org.openrdf.repository.object.RDFObject;

public class DatatypeReader
implements Producer {
    private StringBodyReader delegate = new StringBodyReader();

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<?> type = ftype.asClass();
        if (Set.class.equals(type)) {
            return false;
        }
        if (Object.class.equals(type)) {
            return false;
        }
        if (RDFObject.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.isArray() && Byte.TYPE.equals(type.getComponentType())) {
            return false;
        }
        if (!this.delegate.isProducable(ftype.as((Type)((Object)String.class)), builder)) {
            return false;
        }
        return builder.isDatatype(type);
    }

    @Override
    public Object produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws QueryResultParseException, TupleQueryResultHandlerException, IOException, QueryEvaluationException, RepositoryException {
        Class<?> type = ftype.asClass();
        String value = this.delegate.produce(ftype.as((Type)((Object)String.class)), in, charset, base, builder);
        if (value == null) {
            return null;
        }
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        ObjectFactory of = builder.getObjectFactory();
        URI datatype = vf.createURI("java:", type.getName());
        Literal lit = vf.createLiteral(value, datatype);
        return type.cast(of.createObject(lit));
    }
}

