/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.fluid.helpers.DocumentFactory;
import org.openrdf.http.object.io.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.SAXException;

public class DocumentFragmentMessageReader
implements Producer {
    private TransformerFactory factory = TransformerFactory.newInstance();
    private DocumentFactory builder = DocumentFactory.newInstance();

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<DocumentFragment> type = ftype.asClass();
        if (!ftype.isXML()) {
            return false;
        }
        return type.isAssignableFrom(DocumentFragment.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentFragment produce(FluidType ftype, ReadableByteChannel ch, Charset charset, String base, FluidBuilder builder) throws TransformerException, SAXException, IOException, ParserConfigurationException {
        try {
            InputStream in = ChannelUtil.newInputStream(ch);
            Document doc = this.createDocument(in, charset, base);
            if (doc == null) {
                DocumentFragment documentFragment = null;
                return documentFragment;
            }
            DocumentFragment node = this.createNode();
            DOMResult result = new DOMResult(node);
            DOMSource source = this.createSource(base, doc);
            Transformer transformer = this.factory.newTransformer();
            ErrorCatcher listener = new ErrorCatcher();
            transformer.setErrorListener(listener);
            transformer.transform(source, result);
            if (listener.isFatal()) {
                throw listener.getFatalError();
            }
            DocumentFragment documentFragment = node;
            return documentFragment;
        }
        finally {
            if (ch != null) {
                ch.close();
            }
        }
    }

    private DOMSource createSource(String base, Document doc) {
        if (base == null) {
            return new DOMSource(doc);
        }
        return new DOMSource(doc, base);
    }

    private DocumentFragment createNode() throws ParserConfigurationException {
        Document doc = this.builder.newDocument();
        return doc.createDocumentFragment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(InputStream in, Charset charset, String base) throws TransformerException, SAXException, IOException, ParserConfigurationException {
        if (charset == null) {
            try {
                if (base == null) {
                    Document document = this.builder.parse(in);
                    return document;
                }
                Document document = this.builder.parse(in, base);
                return document;
            }
            finally {
                in.close();
            }
        }
        InputStreamReader reader = new InputStreamReader(in, charset);
        try {
            if (base == null) {
                Document document = this.builder.parse(reader);
                return document;
            }
            Document document = this.builder.parse(reader, base);
            return document;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    static class ErrorCatcher
    implements ErrorListener {
        private Logger logger = LoggerFactory.getLogger(ErrorCatcher.class);
        private TransformerException fatal;

        ErrorCatcher() {
        }

        public boolean isFatal() {
            return this.fatal != null;
        }

        public TransformerException getFatalError() {
            return this.fatal;
        }

        @Override
        public void error(TransformerException exception) {
            this.logger.warn(exception.toString(), (Throwable)exception);
        }

        @Override
        public void fatalError(TransformerException exception) {
            if (this.fatal == null) {
                this.fatal = exception;
            }
            this.logger.error(exception.toString(), (Throwable)exception);
        }

        @Override
        public void warning(TransformerException exception) {
            this.logger.info(exception.toString(), (Throwable)exception);
        }
    }
}

