/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;

public final class FormMapMessageReader
implements Producer {
    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        if (!ftype.isMap()) {
            return false;
        }
        return ftype.is("application/x-www-form-urlencoded");
    }

    @Override
    public Object produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws Exception {
        try {
            FluidType vtype;
            if (charset == null) {
                charset = Charset.forName("ISO-8859-1");
            }
            if ((vtype = ftype.component("text/plain")).isUnknown()) {
                vtype = vtype.as((Type)((Object)String[].class));
                ftype = ftype.as(new ParameterizedType(){

                    @Override
                    public Type getRawType() {
                        return Map.class;
                    }

                    @Override
                    public Type getOwnerType() {
                        return null;
                    }

                    @Override
                    public Type[] getActualTypeArguments() {
                        return new Type[]{String.class, String[].class};
                    }
                });
            }
            FluidType ktype = ftype.key("text/plain");
            Class<Object> kc = ftype.key().asClass();
            if (Object.class.equals(kc)) {
                kc = String.class;
                ktype = ktype.as((Type)((Object)String.class));
            }
            LinkedHashMap<Object, Collection<Object>> parameters = new LinkedHashMap<Object, Collection<Object>>();
            Scanner scanner = new Scanner(in, charset.name());
            scanner.useDelimiter("[&;]");
            while (scanner.hasNext()) {
                String[] nameValue = scanner.next().split("=", 2);
                if (nameValue.length == 0 || nameValue.length > 2) continue;
                String name = this.decode(nameValue[0]);
                Fluid kf = builder.consume(name, base, (Type)((Object)String.class), "text/plain", "text/*");
                Object key = kf.as(ktype);
                if (nameValue.length < 2) {
                    if (parameters.containsKey(key)) continue;
                    parameters.put(key, new ArrayList());
                    continue;
                }
                String value = this.decode(nameValue[1]);
                ArrayList<Object> values = (ArrayList<Object>)parameters.get(key);
                if (values == null) {
                    values = new ArrayList<Object>();
                    parameters.put(key, values);
                }
                Fluid vf = builder.consume(value, base, (Type)((Object)String.class), "text/plain", "text/*");
                if (vtype.isSetOrArray()) {
                    values.add(vf.as(vtype.component("text/plain")));
                    continue;
                }
                values.add(vf.as(vtype));
            }
            Object object = ftype.castMap(parameters);
            return object;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private String decode(String v) throws UnsupportedEncodingException {
        return URLDecoder.decode(v, "UTF-8");
    }
}

