/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;

public class FormStringMessageReader
implements Producer {
    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        return ftype.is((Type)((Object)String.class)) && ftype.is("application/x-www-form-urlencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws IOException {
        BufferedReader reader;
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        if ((reader = ChannelUtil.newReader(in, charset)) == null) {
            return null;
        }
        try {
            int read;
            StringWriter writer = new StringWriter();
            char[] cbuf = new char[512];
            while ((read = reader.read(cbuf)) >= 0) {
                writer.write(cbuf, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

