/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import org.openrdf.http.object.concurrent.ManagedExecutors;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.producers.base.MessageReaderBase;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.util.BackgroundGraphResult;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.turtle.TurtleParserFactory;

public class GraphMessageReader
extends MessageReaderBase<RDFFormat, RDFParserFactory, GraphQueryResult> {
    private static Executor executor = ManagedExecutors.getInstance().getParserThreadPool();

    public GraphMessageReader() {
        super(RDFParserRegistry.getInstance(), GraphQueryResult.class);
    }

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        String mimeType = ftype.preferred();
        if (mimeType != null && mimeType.startsWith("text/plain")) {
            return false;
        }
        return super.isProducable(ftype, builder);
    }

    @Override
    public GraphQueryResult readFrom(RDFParserFactory factory, ReadableByteChannel cin, Charset charset, String base) {
        if (cin == null) {
            return null;
        }
        RDFParser parser = factory.getParser();
        InputStream in = ChannelUtil.newInputStream(cin);
        BackgroundGraphResult result = new BackgroundGraphResult(parser, in, charset, base);
        executor.execute(result);
        return result;
    }

    static {
        RDFFormat format = RDFFormat.forMIMEType((String)"text/turtle");
        if (format == null) {
            format = new RDFFormat("text/turtle", "text/turtle", Charset.forName("UTF-8"), "ttl", true, false);
            RDFFormat.register((RDFFormat)format);
        }
        final RDFFormat turtle = format;
        RDFParserRegistry registry = RDFParserRegistry.getInstance();
        RDFParserFactory factory = (RDFParserFactory)registry.get((Object)turtle);
        if (factory == null) {
            registry.add((Object)new TurtleParserFactory(){

                public RDFFormat getRDFFormat() {
                    return turtle;
                }
            });
        }
    }
}

