/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.io.AbstractSessionInputBuffer;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.MediaType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageReader
implements Producer {
    private Logger logger = LoggerFactory.getLogger(HttpMessageReader.class);

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<?> type = ftype.asClass();
        if (Object.class.equals(type)) {
            return ftype.is("message/http");
        }
        return HttpResponse.class.equals(type) || HttpMessage.class.equals(type) || HttpRequest.class.equals(type) || HttpEntityEnclosingRequest.class.equals(type);
    }

    public HttpMessage produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws IOException {
        return this.readFrom(ftype.as("message/http", "application/http", "message/*").preferred(), in);
    }

    public HttpMessage readFrom(String mimeType, ReadableByteChannel in) throws IOException {
        Header contentEncodingHeader;
        BasicHttpResponse msg;
        if (in == null) {
            return null;
        }
        LineParser parser = this.getParser(mimeType);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        final BufferedInputStream bin = new BufferedInputStream(ChannelUtil.newInputStream(in));
        String line = this.readLine(bin, out);
        if (line.startsWith("HTTP/")) {
            StatusLine status = BasicLineParser.parseStatusLine((String)line, (LineParser)parser);
            parser = new BasicLineParser(status.getProtocolVersion());
            msg = new BasicHttpResponse(status);
        } else {
            RequestLine req = BasicLineParser.parseRequestLine((String)line, (LineParser)parser);
            parser = new BasicLineParser(req.getProtocolVersion());
            msg = new BasicHttpEntityEnclosingRequest(req);
        }
        line = this.readLine(bin, out);
        while (line.length() > 2) {
            Header hd = BasicLineParser.parseHeader((String)line, (LineParser)parser);
            msg.addHeader(hd);
            line = this.readLine(bin, out);
        }
        Header length = msg.getFirstHeader("Content-Length");
        Header encoding = msg.getFirstHeader("Transfer-Encoding");
        if (encoding == null && length == null) {
            bin.close();
            if (msg instanceof BasicHttpEntityEnclosingRequest) {
                BasicHttpEntityEnclosingRequest req = (BasicHttpEntityEnclosingRequest)msg;
                msg = new BasicHttpRequest(req.getRequestLine());
                msg.setHeaders(req.getAllHeaders());
            }
            return msg;
        }
        BasicHttpEntity entity = new BasicHttpEntity();
        if (encoding != null && "chunked".equals(encoding)) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent((InputStream)new ChunkedInputStream(this.createBuffer(bin)){

                public void close() throws IOException {
                    super.close();
                    bin.close();
                }
            });
        } else if (encoding != null) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent((InputStream)bin);
        } else if (length != null) {
            long len = Long.parseLong(length.getValue());
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent((InputStream)new ContentLengthInputStream(this.createBuffer(bin), len){

                public void close() throws IOException {
                    super.close();
                    bin.close();
                }
            });
        }
        Header contentTypeHeader = msg.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = msg.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        if (msg instanceof BasicHttpEntityEnclosingRequest) {
            ((BasicHttpEntityEnclosingRequest)msg).setEntity((HttpEntity)entity);
        } else if (msg instanceof HttpResponse) {
            ((HttpResponse)msg).setEntity((HttpEntity)entity);
        }
        return msg;
    }

    private SessionInputBuffer createBuffer(final BufferedInputStream bin) {
        return new AbstractSessionInputBuffer(){
            {
                this.init(bin, 1024, (HttpParams)new BasicHttpParams());
            }

            public boolean isDataAvailable(int timeout) throws IOException {
                return bin.available() > 0;
            }
        };
    }

    private String readLine(BufferedInputStream bin, ByteArrayOutputStream out) throws IOException {
        int read;
        while ((read = bin.read()) >= 0) {
            out.write(read);
            if (10 != read) continue;
        }
        String line = new String(out.toByteArray(), Charset.forName("ISO-8859-1"));
        out.reset();
        return line.trim();
    }

    private LineParser getParser(String mimeType) {
        try {
            if (mimeType == null) {
                return new BasicLineParser();
            }
            if (!mimeType.startsWith("message/http") && !mimeType.startsWith("application/http")) {
                return new BasicLineParser();
            }
            if (!mimeType.contains("version")) {
                return new BasicLineParser();
            }
            MediaType m = MediaType.valueOf(mimeType);
            String version = m.getParameter("version");
            if (version == null) {
                return new BasicLineParser();
            }
            int idx = version.indexOf(46);
            if (idx < 0) {
                return new BasicLineParser();
            }
            int major = Integer.parseInt(version.substring(0, idx));
            int minor = Integer.parseInt(version.substring(idx + 1));
            ProtocolVersion ver = new ProtocolVersion("HTTP", major, minor);
            return new BasicLineParser(ver);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug(e.toString(), (Throwable)e);
            return new BasicLineParser();
        }
    }
}

