/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.openrdf.http.object.fluid.producers.GraphMessageReader;
import org.openrdf.http.object.fluid.producers.base.MessageReaderBase;
import org.openrdf.model.Model;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;

public class ModelMessageReader
extends MessageReaderBase<RDFFormat, RDFParserFactory, Model> {
    private GraphMessageReader delegate = new GraphMessageReader();

    public ModelMessageReader() {
        super(RDFParserRegistry.getInstance(), Model.class);
    }

    @Override
    public Model readFrom(RDFParserFactory factory, ReadableByteChannel in, Charset charset, String base) throws QueryEvaluationException {
        GraphQueryResult result = this.delegate.readFrom(factory, in, charset, base);
        Map map = result.getNamespaces();
        LinkedHashSet<NamespaceImpl> namespaces = new LinkedHashSet<NamespaceImpl>(map.size());
        for (Map.Entry e : map.entrySet()) {
            namespaces.add(new NamespaceImpl((String)e.getKey(), (String)e.getValue()));
        }
        return new LinkedHashModel(namespaces, (Collection)Iterations.asList((Iteration)result));
    }
}

