/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;
import org.xml.sax.SAXException;

public class PrimitiveBodyReader
implements Producer {
    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        return this.isPrimitive(ftype.asClass()) && ftype.is("text/*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws OpenRDFException, IOException, XMLStreamException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
        if (in == null && ftype.is(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (in == null && ftype.isPrimitive()) {
            return this.valueOf("0", ftype.asClass());
        }
        if (in == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        InputStream stream = ChannelUtil.newInputStream(in);
        InputStreamReader isr = new InputStreamReader(stream, charset);
        BufferedReader reader = new BufferedReader(isr);
        try {
            String value = reader.readLine();
            Object object = this.valueOf(value, ftype.asClass());
            return object;
        }
        finally {
            reader.close();
        }
    }

    private boolean isPrimitive(Class<?> asClass) {
        return asClass.isPrimitive() || this.isPrimitiveWrapper(asClass);
    }

    private boolean isPrimitiveWrapper(Class<?> asClass) {
        if (Boolean.class.equals(asClass)) {
            return true;
        }
        if (Byte.class.equals(asClass)) {
            return true;
        }
        if (Short.class.equals(asClass)) {
            return true;
        }
        if (Character.class.equals(asClass)) {
            return true;
        }
        if (Integer.class.equals(asClass)) {
            return true;
        }
        if (Long.class.equals(asClass)) {
            return true;
        }
        if (Float.class.equals(asClass)) {
            return true;
        }
        return Double.class.equals(asClass);
    }

    private Object valueOf(String value, Class<?> type) {
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return Boolean.valueOf(value);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return Character.valueOf(value.charAt(0));
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return Byte.valueOf(value);
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return Short.valueOf(value);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.valueOf(value);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(value);
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.valueOf(value);
        }
        return null;
    }
}

