/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;

public class StringBodyReader
implements Producer {
    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<String> cls = ftype.asClass();
        if (Object.class.equals(cls)) {
            return false;
        }
        return cls.isAssignableFrom(String.class) && ftype.is("text/*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws IOException {
        if (in == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        BufferedReader reader = ChannelUtil.newReader(in, charset);
        try {
            int read;
            StringWriter writer = new StringWriter();
            char[] cbuf = new char[512];
            while ((read = reader.read(cbuf)) >= 0) {
                writer.write(cbuf, 0, read);
            }
            String str = writer.toString();
            if (str.length() == 0) {
                String string = null;
                return string;
            }
            String string = str;
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

