/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.openrdf.http.object.fluid.producers.base.MessageReaderBase;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.helpers.QueryResultCollector;

public class TupleMessageReader
extends MessageReaderBase<TupleQueryResultFormat, TupleQueryResultParserFactory, TupleQueryResult> {
    public TupleMessageReader() {
        super(TupleQueryResultParserRegistry.getInstance(), TupleQueryResult.class);
    }

    @Override
    public TupleQueryResult readFrom(TupleQueryResultParserFactory factory, final ReadableByteChannel ch, Charset charset, String base) throws QueryResultParseException, QueryResultHandlerException, IOException {
        if (ch == null) {
            return null;
        }
        QueryResultCollector col = new QueryResultCollector();
        TupleQueryResultParser parser = factory.getParser();
        parser.setQueryResultHandler((QueryResultHandler)col);
        parser.parseQueryResult((InputStream)new FilterInputStream(Channels.newInputStream(ch)){

            @Override
            public int available() throws IOException {
                int available = super.available();
                if (available == 0 && ch.isOpen()) {
                    return 1;
                }
                return available;
            }

            public String toString() {
                return this.in.toString();
            }
        });
        col.endQueryResult();
        if (col.getBindingNames().isEmpty()) {
            return null;
        }
        return new TupleQueryResultImpl(col.getBindingNames(), (Iterable)col.getBindingSets());
    }
}

