/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.io.XMLEventReaderFactory;

public class XMLEventMessageReader
implements Producer {
    private XMLEventReaderFactory factory = XMLEventReaderFactory.newInstance();

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        return ftype.asClass().isAssignableFrom(XMLEventReader.class) && ftype.isXML();
    }

    @Override
    public XMLEventReader produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws IOException, XMLStreamException {
        if (in == null) {
            return null;
        }
        InputStream stream = ChannelUtil.newInputStream(in);
        if (charset == null) {
            return this.factory.createXMLEventReader(base, stream);
        }
        return this.factory.createXMLEventReader(base, new InputStreamReader(stream, charset));
    }
}

