/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers.base;

import info.aduna.lang.FileFormat;
import info.aduna.lang.service.FileFormatServiceRegistry;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;

public abstract class MessageReaderBase<FF extends FileFormat, S, T>
implements Producer {
    private FileFormatServiceRegistry<FF, S> registry;
    private final String[] mimeTypes;
    private Class<T> type;

    public MessageReaderBase(FileFormatServiceRegistry<FF, S> registry, Class<T> type) {
        this.registry = registry;
        this.type = type;
        LinkedHashSet set = new LinkedHashSet();
        for (FileFormat format : registry.getKeys()) {
            set.addAll(format.getMIMETypes());
        }
        this.mimeTypes = set.toArray(new String[set.size()]);
    }

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<?> type = ftype.asClass();
        if (Object.class.equals(type)) {
            return false;
        }
        if (!this.classEquals(type)) {
            return false;
        }
        FluidType possible = new FluidType(ftype.asType(), this.mimeTypes).as(ftype);
        return this.getFactory(possible.preferred()) != null;
    }

    @Override
    public Object produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws QueryResultParseException, QueryResultHandlerException, IOException, QueryEvaluationException {
        FluidType possible = new FluidType(ftype.asType(), this.mimeTypes).as(ftype);
        return this.readFrom(this.getFactory(possible.preferred()), in, charset, base);
    }

    public abstract T readFrom(S var1, ReadableByteChannel var2, Charset var3, String var4) throws QueryResultParseException, QueryResultHandlerException, IOException, QueryEvaluationException;

    protected boolean classEquals(Class<?> type) {
        return type.equals(this.type);
    }

    protected S getFactory(String mime) {
        if (mime == null) {
            return null;
        }
        FF format = this.getFormat(mime);
        if (format == null) {
            return null;
        }
        return (S)this.registry.get(format);
    }

    protected FF getFormat(String mimeType) {
        if (mimeType == null || mimeType.contains("*") || "application/octet-stream".equals(mimeType)) {
            for (FileFormat format : this.registry.getKeys()) {
                if (this.registry.get((Object)format) == null) continue;
                return (FF)format;
            }
            return null;
        }
        int idx = mimeType.indexOf(59);
        if (idx > 0) {
            mimeType = mimeType.substring(0, idx);
        }
        return (FF)this.registry.getFileFormatForMIMEType(mimeType);
    }
}

