/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.fluid.producers.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.fluid.Producer;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.util.URLUtil;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.repository.RepositoryException;

public abstract class URIListReader<URI>
implements Producer {
    private Class<URI> componentType;
    public static URIListReader<org.openrdf.model.URI> RDF_URI = new URIListReader<org.openrdf.model.URI>(org.openrdf.model.URI.class){

        @Override
        protected org.openrdf.model.URI create(String uri) {
            ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
            return vf.createURI(uri);
        }
    };
    public static URIListReader<URL> NET_URL = new URIListReader<URL>(URL.class){

        @Override
        protected URL create(String uri) throws MalformedURLException {
            return new URL(uri);
        }
    };
    public static URIListReader<URI> NET_URI = new URIListReader<URI>(URI.class){

        @Override
        protected URI create(String uri) {
            return URI.create(uri);
        }
    };

    public URIListReader(Class<URI> componentType) {
        this.componentType = componentType;
    }

    public String toString() {
        if (this.componentType == null) {
            return super.toString();
        }
        return this.componentType.getName();
    }

    @Override
    public boolean isProducable(FluidType ftype, FluidBuilder builder) {
        Class<URI> ctype = ftype.asClass();
        if (this.componentType != null) {
            if (!this.componentType.equals(ctype) && Object.class.equals(ctype)) {
                return false;
            }
            if (ftype.isSetOrArray()) {
                Class<URI> component = ftype.component().asClass();
                if (!this.componentType.equals(component) && Object.class.equals(component)) {
                    return false;
                }
                if (!component.isAssignableFrom(this.componentType)) {
                    return false;
                }
            } else if (!ctype.isAssignableFrom(this.componentType)) {
                return false;
            }
        }
        return ftype.is("text/uri-list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object produce(FluidType ftype, ReadableByteChannel in, Charset charset, String base, FluidBuilder builder) throws QueryResultParseException, TupleQueryResultHandlerException, IOException, QueryEvaluationException, RepositoryException {
        if (in == null) {
            return null;
        }
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        BufferedReader reader = ChannelUtil.newReader(in, charset);
        try {
            String str;
            LinkedHashSet<URI> set = new LinkedHashSet<URI>();
            while ((str = reader.readLine()) != null) {
                if (str.startsWith("#") || str.isEmpty()) continue;
                URI url = base != null ? this.create(URLUtil.resolve(str.trim(), base)) : this.create(this.canonicalize(str.trim()));
                set.add(url);
            }
            Object object = ftype.castSet(set);
            return object;
        }
        finally {
            reader.close();
        }
    }

    protected abstract URI create(String var1) throws MalformedURLException, RepositoryException;

    private String canonicalize(String uri) {
        return URLUtil.canonicalize(uri);
    }
}

