/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.io.IOException;
import java.net.URI;
import java.util.Queue;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.InternalServerError;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.helpers.Exchange;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRequestHandler
implements HttpAsyncRequestHandlerMapper,
HttpAsyncRequestHandler<HttpRequest> {
    final Logger logger = LoggerFactory.getLogger(AsyncRequestHandler.class);
    private final AsyncExecChain handler;

    public AsyncRequestHandler(AsyncExecChain handler) {
        this.handler = handler;
    }

    public HttpAsyncRequestHandler<?> lookup(HttpRequest request) {
        return this;
    }

    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            this.logger.debug("Request received {}", (Object)request.getRequestLine());
            ObjectContext cc = ObjectContext.adapt(context);
            Request req = new Request(request, cc);
            Queue<Exchange> queue = cc.getOrCreateProcessingQueue();
            Exchange exchange = new Exchange(req, queue);
            cc.setExchange(exchange);
            this.handle(req, cc, exchange);
            return exchange.getConsumer();
        }
        catch (IllegalArgumentException e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    public void handle(HttpRequest request, HttpAsyncExchange trigger, HttpContext context) throws HttpException, IOException {
        this.logger.debug("Request consumed {}", (Object)request.getRequestLine());
        ObjectContext ctx = ObjectContext.adapt(context);
        Exchange exchange = ctx.getExchange();
        assert (exchange != null);
        exchange.setHttpAsyncExchange(trigger);
        ctx.setExchange(null);
    }

    private void handle(final Request req, HttpContext context, final Exchange exchange) {
        ObjectContext cc = ObjectContext.fork(context);
        HttpHost host = URIUtils.extractHost((URI)URI.create(req.getOrigin() + "/"));
        try {
            this.handler.execute(host, req.getEnclosingRequest(), cc, new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse result) {
                    try {
                        exchange.submitResponse(result);
                    }
                    catch (RuntimeException ex) {
                        this.failed(ex);
                    }
                }

                public void failed(Exception ex) {
                    ResponseException e;
                    if (ex instanceof ResponseException) {
                        e = (ResponseException)ex;
                        if (e.getCause() == null) {
                            if (e.getStatusCode() < 500) {
                                AsyncRequestHandler.this.logger.warn(e.getDetailMessage());
                            } else {
                                AsyncRequestHandler.this.logger.error(e.getDetailMessage());
                            }
                        } else {
                            AsyncRequestHandler.this.logger.error(e.getLongMessage(), (Throwable)e);
                        }
                    } else {
                        AsyncRequestHandler.this.logger.error(ex.toString(), (Throwable)ex);
                        e = new InternalServerError(ex);
                    }
                    HttpUriResponse result = new ResponseBuilder(req).exception(e);
                    exchange.submitResponse((HttpResponse)result);
                }

                public void cancelled() {
                    BasicHttpResponse _500 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "Internal Server Error");
                    exchange.submitResponse((HttpResponse)_500);
                }
            });
        }
        catch (ResponseException ex) {
            this.logger.error(ex.toString(), (Throwable)ex);
            HttpUriResponse result = new ResponseBuilder(req).exception(ex);
            exchange.submitResponse((HttpResponse)result);
        }
        catch (Exception ex) {
            this.logger.error(ex.toString(), (Throwable)ex);
            HttpUriResponse result = new ResponseBuilder(req).exception(new InternalServerError(ex));
            exchange.submitResponse((HttpResponse)result);
        }
    }
}

