/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.HttpParams;

public class EditableHttpEntityEnclosingRequest
implements HttpEntityEnclosingRequest,
Cloneable {
    private HttpRequest request;
    private RequestLine requestLine;
    private HttpEntity entity;
    private HttpParams params;

    public EditableHttpEntityEnclosingRequest(HttpRequest request) {
        this.request = request;
        this.requestLine = request.getRequestLine();
        this.params = request.getParams();
    }

    public HttpRequest getEnclosingRequest() {
        return this.request;
    }

    public EditableHttpEntityEnclosingRequest clone() {
        EditableHttpEntityEnclosingRequest cloned;
        try {
            cloned = (EditableHttpEntityEnclosingRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        cloned.request = new BasicHttpEntityEnclosingRequest(this.requestLine);
        cloned.request.setHeaders(this.request.getAllHeaders());
        cloned.request.setParams(this.params);
        cloned.setEntity(this.getEntity());
        return cloned;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public boolean expectContinue() {
        if (this.request instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)this.request).expectContinue();
        }
        return false;
    }

    public HttpEntity getEntity() {
        if (this.entity != null) {
            return this.entity;
        }
        if (this.request instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)this.request).getEntity();
        }
        return null;
    }

    public void setEntity(HttpEntity entity) {
        if (this.entity == null && this.request instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
        } else {
            this.entity = entity;
        }
    }

    public void addHeader(Header header) {
        this.request.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.request.containsHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.request.getAllHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.request.getFirstHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Header getLastHeader(String name) {
        return this.request.getLastHeader(name);
    }

    public HttpParams getParams() {
        return this.params;
    }

    public HeaderIterator headerIterator() {
        return this.request.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.request.headerIterator(name);
    }

    public void removeHeader(Header header) {
        this.request.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.request.removeHeaders(name);
    }

    public void setHeader(Header header) {
        this.request.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.request.setHeaders(headers);
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }
}

