/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openrdf.http.object.client.StreamingHttpEntity;
import org.openrdf.http.object.helpers.LoggingResponseProducer;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.io.AsyncPipe;
import org.openrdf.http.object.io.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exchange
implements Cancellable {
    final Logger logger = LoggerFactory.getLogger(Exchange.class);
    private Request request;
    private final Queue<Exchange> queue;
    private final Consumer consumer;
    private HttpAsyncExchange exchange;
    private HttpResponse response;
    private HttpAsyncResponseProducer producer;
    private int timeout = -1;
    private boolean expectContinue;
    private HttpAsyncResponseProducer submitContinue;
    private boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange(Request request, Queue<Exchange> queue) throws IOException {
        assert (request != null);
        assert (queue != null);
        this.request = request;
        this.queue = queue;
        Header expect = request.getFirstHeader("Expect");
        this.setExpectContinue(expect != null && expect.getValue().equalsIgnoreCase("100-continue"));
        Queue<Exchange> queue2 = queue;
        synchronized (queue2) {
            queue.add(this);
        }
        this.consumer = new Consumer((HttpRequest)request);
    }

    public HttpAsyncRequestConsumer<HttpRequest> getConsumer() {
        return this.consumer;
    }

    public String toString() {
        return this.getRequest().toString();
    }

    public synchronized Request getRequest() {
        return this.request;
    }

    public synchronized void setRequest(Request request) {
        this.request = request;
    }

    public synchronized void submitContinue(HttpResponse response) {
        if (this.expectContinue && response != null) {
            this.submitContinue = new LoggingResponseProducer(response);
            if (this.exchange != null) {
                this.exchange.submitResponse(this.submitContinue);
            }
        }
    }

    public synchronized HttpAsyncExchange getHttpAsyncExchange() {
        return this.exchange;
    }

    public synchronized void setHttpAsyncExchange(HttpAsyncExchange exchange) {
        assert (exchange != null);
        this.exchange = exchange;
        exchange.setCallback((Cancellable)this);
        if (this.timeout != -1) {
            exchange.setTimeout(this.timeout);
        }
        if (this.response != null) {
            this.producer = new LoggingResponseProducer(this.response);
            exchange.submitResponse(this.producer);
        } else if (this.submitContinue != null) {
            exchange.submitResponse(this.submitContinue);
        }
    }

    public synchronized boolean isPendingVerification() {
        return this.submitContinue == null && this.expectContinue;
    }

    public synchronized boolean isReadingRequest() {
        return this.exchange == null;
    }

    public synchronized boolean isPendingResponse() {
        return this.response == null;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isCompleted() {
        return this.exchange != null && this.exchange.isCompleted();
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.exchange != null) {
            this.exchange.setTimeout(timeout);
        }
    }

    public synchronized int getTimeout() {
        if (this.exchange == null) {
            return this.timeout;
        }
        return this.exchange.getTimeout();
    }

    public synchronized void submitResponse(HttpResponse response) {
        this.closeRequest();
        assert (response != null);
        if (this.cancelled || this.response != null && this.exchange != null) {
            this.consume(response);
        } else if (this.response != null) {
            this.consume(this.response);
            this.response = response;
        } else if (this.exchange != null) {
            this.response = response;
            this.producer = new LoggingResponseProducer(response);
            this.exchange.submitResponse(this.producer);
        } else {
            this.response = response;
        }
    }

    public synchronized boolean cancel() {
        this.cancelled = true;
        this.closeRequest();
        if (this.response != null) {
            this.consume(this.response);
        }
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (IOException e) {
                this.logger.debug(e.toString(), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeRequest() {
        if (this.consumer != null) {
            this.consumer.close();
        }
        EntityUtils.consumeQuietly((HttpEntity)this.request.getEntity());
        if (this.queue != null) {
            Queue<Exchange> queue = this.queue;
            synchronized (queue) {
                this.queue.remove(this);
            }
        }
    }

    synchronized void setExpectContinue(boolean expectContinue) {
        this.expectContinue = expectContinue;
    }

    private void consume(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }

    private class Consumer
    implements HttpAsyncRequestConsumer<HttpRequest> {
        private final HttpRequest request;
        private AsyncPipe pipe;
        private Exception ex;

        public Consumer(HttpRequest request) {
            this(request, 65536);
        }

        public Consumer(HttpRequest request, int capacity) {
            this.request = request;
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest ereq = (HttpEntityEnclosingRequest)request;
                HttpEntity entity = ereq.getEntity();
                if (entity == null) {
                    this.pipe = null;
                } else {
                    this.pipe = new AsyncPipe(capacity);
                    entity = new StreamingHttpEntity(entity){

                        @Override
                        protected InputStream getDelegateContent() throws IOException {
                            return ChannelUtil.newInputStream(Consumer.this.pipe.source());
                        }
                    };
                    ereq.setEntity(entity);
                }
            } else {
                this.pipe = null;
            }
        }

        public void requestReceived(HttpRequest request) throws HttpException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeContent(final ContentDecoder decoder, final IOControl ioctrl) throws IOException {
            Exchange.this.setExpectContinue(false);
            assert (this.pipe != null);
            if (this.pipe.isStale()) {
                try {
                    Exchange.this.cancel();
                }
                finally {
                    ioctrl.shutdown();
                }
                return;
            }
            this.pipe.sink(new AsyncPipe.Sink(){

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    return decoder.read(dst);
                }
            });
            if (decoder.isCompleted()) {
                this.pipe.close();
            } else if (!this.pipe.hasAvailableCapacity()) {
                AsyncPipe asyncPipe = this.pipe;
                synchronized (asyncPipe) {
                    if (!this.pipe.hasAvailableCapacity()) {
                        Exchange.this.logger.info("Suspend {}", (Object)this.request.getRequestLine());
                        ioctrl.suspendInput();
                        this.pipe.onAvailableCapacity(new Runnable(){

                            @Override
                            public void run() {
                                Exchange.this.logger.info("Resume {}", (Object)Consumer.this.request.getRequestLine());
                                ioctrl.requestInput();
                            }
                        });
                    }
                }
            }
        }

        public void close() {
            if (this.pipe != null) {
                this.pipe.close();
            }
        }

        public void requestCompleted(HttpContext context) {
            this.close();
        }

        public void failed(Exception ex) {
            this.ex = ex;
            if (this.pipe != null) {
                this.pipe.fail(ex);
            }
        }

        public Exception getException() {
            return this.ex;
        }

        public HttpRequest getResult() {
            return this.request;
        }

        public boolean isDone() {
            return this.pipe == null || !this.pipe.isOpen();
        }

        public String toString() {
            return String.valueOf(this.request);
        }
    }
}

