/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.helpers.Exchange;
import org.openrdf.http.object.helpers.ResourceTarget;

public class ObjectContext
implements HttpContext {
    private static final String PROTOCOL_SCHEME = "http.protocol.scheme";
    private static final String NS = ObjectContext.class.getName() + "#";
    private static final String CLIENT_ATTR = NS + "clientAddr";
    private static final String EXCHANGE_ATTR = NS + "exchange";
    private static final String PROCESSING_ATTR = NS + "processing";
    private static final String RECEIVED_ATTR = NS + "receivedOn";
    private static final String TRANSACTION_ATTR = NS + "resourceTransaction";
    private static final String HEAD_ATTR = NS + "headResponse";
    private static final String ORIG_REQUEST_ATTR = NS + "originalRequest";
    private final HttpContext context;

    public static ObjectContext adapt(HttpContext context) {
        if (context instanceof ObjectContext) {
            return (ObjectContext)context;
        }
        return new ObjectContext(context);
    }

    public static ObjectContext fork(HttpContext context) {
        ObjectContext forked = ObjectContext.adapt((HttpContext)new BasicHttpContext(context));
        forked.setClientAddr(forked.getClientAddr());
        forked.setExchange(forked.getExchange());
        forked.setProtocolScheme(forked.getProtocolScheme());
        forked.setReceivedOn(forked.getReceivedOn());
        forked.setResourceTarget(forked.getResourceTarget());
        return forked;
    }

    public static ObjectContext create() {
        return new ObjectContext((HttpContext)new BasicHttpContext());
    }

    public ObjectContext() {
        this.context = new BasicHttpContext();
    }

    public ObjectContext(HttpContext context) {
        this.context = context;
    }

    public String toString() {
        return this.context.toString();
    }

    public Object getAttribute(String id) {
        return this.context.getAttribute(id);
    }

    public Object removeAttribute(String id) {
        return this.context.removeAttribute(id);
    }

    public void setAttribute(String id, Object obj) {
        this.context.setAttribute(id, obj);
    }

    public String getProtocolScheme() {
        return this.getAttribute(PROTOCOL_SCHEME, String.class);
    }

    public void setProtocolScheme(String scheme) {
        this.setAttribute(PROTOCOL_SCHEME, scheme);
    }

    public long getReceivedOn() {
        Long ret = this.getAttribute(RECEIVED_ATTR, Long.class);
        return ret == null ? 0L : ret;
    }

    public void setReceivedOn(long received) {
        this.setAttribute(RECEIVED_ATTR, received);
    }

    public InetAddress getClientAddr() {
        return this.getAttribute(CLIENT_ATTR, InetAddress.class);
    }

    public void setClientAddr(InetAddress addr) {
        this.setAttribute(CLIENT_ATTR, addr);
    }

    public ResourceTarget getResourceTarget() {
        return this.getAttribute(TRANSACTION_ATTR, ResourceTarget.class);
    }

    public void setResourceTarget(ResourceTarget trans) {
        this.setAttribute(TRANSACTION_ATTR, trans);
    }

    public HttpResponse getDerivedFromHeadResponse() {
        return this.getAttribute(HEAD_ATTR, HttpResponse.class);
    }

    public void setDerivedFromHeadResponse(HttpResponse head) {
        this.setAttribute(HEAD_ATTR, head);
    }

    public HttpRequest getOriginalRequest() {
        return this.getAttribute(ORIG_REQUEST_ATTR, HttpRequest.class);
    }

    public void setOriginalRequest(HttpRequest request) {
        this.setAttribute(ORIG_REQUEST_ATTR, request);
    }

    public Exchange getExchange() {
        return this.getAttribute(EXCHANGE_ATTR, Exchange.class);
    }

    public void setExchange(Exchange exchange) {
        if (exchange == null) {
            this.removeAttribute(EXCHANGE_ATTR);
        } else {
            this.setAttribute(EXCHANGE_ATTR, exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange[] getPendingExchange() {
        NHttpConnection conn = (NHttpConnection)this.context.getAttribute("http.connection");
        HttpContext ctx = conn == null ? this.context : conn.getContext();
        Queue queue = (Queue)ctx.getAttribute(PROCESSING_ATTR);
        if (queue == null) {
            return null;
        }
        Queue queue2 = queue;
        synchronized (queue2) {
            return queue.toArray(new Exchange[queue.size()]);
        }
    }

    public Queue<Exchange> getOrCreateProcessingQueue() {
        NHttpConnection conn = (NHttpConnection)this.context.getAttribute("http.connection");
        HttpContext ctx = conn == null ? this.context : conn.getContext();
        LinkedList queue = (LinkedList)ctx.getAttribute(PROCESSING_ATTR);
        if (queue == null) {
            queue = new LinkedList();
            ctx.setAttribute(PROCESSING_ATTR, queue);
        }
        return queue;
    }

    private <T> T getAttribute(String attribname, Class<T> clazz) {
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return clazz.cast(obj);
    }
}

