/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.http.HttpConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.openrdf.http.object.helpers.ObjectContext;

public class ObjectContextInterceptor
implements HttpRequestInterceptor {
    private final InetAddress LOCALHOST = this.getLocalHost();
    private final String protocol;

    public ObjectContextInterceptor(String protocol) {
        this.protocol = protocol;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        ObjectContext cc = ObjectContext.adapt(context);
        cc.setReceivedOn(System.currentTimeMillis());
        cc.setClientAddr(this.getRemoteAddress(context));
        cc.setProtocolScheme(this.protocol);
    }

    private InetAddress getRemoteAddress(HttpContext context) {
        InetAddress remoteAddress;
        if (context == null) {
            return this.LOCALHOST;
        }
        HttpConnection con = HttpCoreContext.adapt((HttpContext)context).getConnection();
        if (con instanceof HttpInetConnection && (remoteAddress = ((HttpInetConnection)con).getRemoteAddress()) != null) {
            return remoteAddress;
        }
        return this.LOCALHOST;
    }

    public InetAddress getLocalHost() {
        try {
            return InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces != null && interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses != null && addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address == null || !address.isLoopbackAddress()) continue;
                        return address;
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            throw new AssertionError((Object)"Unknown hostname: add the hostname of the machine to your /etc/hosts file.");
        }
    }
}

