/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.openrdf.http.object.io.AutoCloseChannel;
import org.openrdf.http.object.io.ChannelUtil;

public class ReadableHttpEntityChannel
implements HttpEntity,
HttpAsyncContentProducer {
    private String contentType;
    private long contentLength;
    private ByteBuffer buf = ByteBuffer.allocate(8192);
    private ReadableByteChannel cin;

    public ReadableHttpEntityChannel(String type, long length, ReadableByteChannel in) {
        this(type, length, in, (List<Runnable>)null);
    }

    public ReadableHttpEntityChannel(String type, long length, ReadableByteChannel in, Runnable ... onClose) {
        this(type, length, in, Arrays.asList(onClose));
    }

    private ReadableHttpEntityChannel(String type, long length, ReadableByteChannel in, final List<Runnable> onClose) {
        this.contentType = type;
        this.contentLength = length;
        if (in == null) {
            in = ChannelUtil.newChannel(new byte[0]);
        }
        this.cin = new AutoCloseChannel(in){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (onClose != null) {
                        for (Runnable task : onClose) {
                            try {
                                task.run();
                            }
                            catch (RuntimeException runtimeException) {
                            }
                            catch (Error error) {}
                        }
                    }
                }
            }
        };
    }

    public String toString() {
        return this.cin.toString();
    }

    public final void consumeContent() throws IOException {
        this.finish();
    }

    public InputStream getContent() throws IOException {
        return ChannelUtil.newInputStream(this.cin);
    }

    public ReadableByteChannel getReadableByteChannel() {
        return this.cin;
    }

    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", "identity");
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        if (this.contentType == null) {
            return null;
        }
        return new BasicHeader("Content-Type", this.contentType);
    }

    public boolean isChunked() {
        return this.getContentLength() < 0L;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return this.cin.isOpen();
    }

    public void writeTo(OutputStream out) throws IOException {
        InputStream in = this.getContent();
        try {
            int read;
            byte[] buf = new byte[1024];
            while ((read = in.read(buf)) >= 0) {
                out.write(buf, 0, read);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            in.close();
        }
    }

    public final void finish() throws IOException {
        this.cin.close();
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.cin.read(this.buf) < 0 && this.buf.position() == 0) {
            this.close();
            if (!encoder.isCompleted()) {
                encoder.complete();
            }
        } else {
            this.buf.flip();
            encoder.write(this.buf);
            this.buf.compact();
        }
    }

    public void close() throws IOException {
        this.cin.close();
    }
}

