/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import info.aduna.net.ParsedURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.exceptions.BadRequest;
import org.openrdf.http.object.helpers.EditableHttpEntityEnclosingRequest;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.util.URLUtil;

public class Request
extends EditableHttpEntityEnclosingRequest {
    private final String protocol;
    private final String origin;
    private final String iri;

    public Request(HttpRequest request, HttpContext context) {
        this(request, ObjectContext.adapt(context).getProtocolScheme());
    }

    public Request(HttpRequest request, String protocol) throws IllegalArgumentException {
        super(request);
        String path;
        String uri = request.getRequestLine().getUri();
        if (protocol == null) {
            String msg = "Could not determine protocol for " + uri;
            throw new IllegalStateException(msg);
        }
        this.protocol = protocol;
        int qx = uri.indexOf(63);
        String string = path = qx > 0 ? uri.substring(0, qx) : uri;
        if (path.startsWith("/")) {
            String scheme = this.getScheme().toLowerCase();
            String host = this.getAuthority().toLowerCase();
            ParsedURI parsed = new ParsedURI(scheme, host, path, null, null);
            this.iri = this.canonicalize(parsed.toString());
            this.origin = scheme + "://" + host;
        } else {
            this.iri = this.canonicalize(path);
            ParsedURI parsed = new ParsedURI(this.iri);
            this.origin = parsed.getScheme() + "://" + parsed.getAuthority();
        }
        this.getRequestURL();
    }

    public String getHeader(String name) {
        Header[] headers = this.getHeaders(name);
        if (headers == null || headers.length == 0) {
            return null;
        }
        return headers[0].getValue();
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)value);
        return date != null ? date.getTime() : -1L;
    }

    public String getResolvedHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.resolve(value);
    }

    public final boolean isStorable() {
        return this.isSafe() && !this.isMessageBody() && this.getCacheControl("no-store", 0) == 0;
    }

    public final boolean isSafe() {
        String method = this.getMethod();
        return method.equals("HEAD") || method.equals("GET") || method.equals("OPTIONS") || method.equals("PROFIND");
    }

    public boolean isOnlyIfCache() {
        return this.isStorable() && this.getCacheControl("only-if-cached", 0) > 0;
    }

    public String getMethod() {
        return this.getRequestLine().getMethod();
    }

    public String getQueryString() {
        String qs = this.getRequestLine().getUri();
        int idx = qs.indexOf(63);
        if (idx < 0) {
            return null;
        }
        return qs.substring(idx + 1);
    }

    public String getRequestURL() {
        String uri = this.getRequestLine().getUri();
        if (uri.equals("*")) {
            return "*";
        }
        if (!uri.startsWith("/")) {
            return this.canonicalize(uri);
        }
        String qs = null;
        int qx = uri.indexOf(63);
        if (qx > 0) {
            qs = uri.substring(qx + 1);
            uri = uri.substring(0, qx);
        }
        String scheme = this.getScheme().toLowerCase();
        String host = this.getAuthority().toLowerCase();
        return this.canonicalize(new ParsedURI(scheme, host, uri, qs, null).toString());
    }

    public String getIRI() {
        return this.iri;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getRequestURI() {
        String path = this.getRequestLine().getUri();
        try {
            int qx = path.indexOf(63);
            if (qx > 0) {
                path = path.substring(0, qx);
            }
            if (!path.startsWith("/")) {
                return path;
            }
            String scheme = this.getScheme().toLowerCase();
            String host = this.getAuthority().toLowerCase();
            return new ParsedURI(scheme, host, path, null, null).toString();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e);
        }
    }

    public String resolve(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLUtil.resolve(url, this.getRequestURI());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e);
        }
    }

    public boolean isMessageBody() {
        String length = this.getHeader("Content-Length");
        return length != null && !"0".equals(length) || this.getHeader("Transfer-Encoding") != null;
    }

    public String toString() {
        return this.getRequestLine().toString();
    }

    public String getAuthority() {
        String host;
        String uri = this.getRequestLine().getUri();
        if (uri != null && !uri.equals("*") && !uri.startsWith("/")) {
            try {
                String authority = new URI(uri).getAuthority();
                if (authority != null) {
                    return authority;
                }
            }
            catch (URISyntaxException authority) {
                // empty catch block
            }
        }
        if ((host = this.getHeader("Host")) != null) {
            return host.toLowerCase();
        }
        throw new BadRequest("Missing Host Header for request-uri: " + uri);
    }

    public String getScheme() {
        String uri = this.getRequestLine().getUri();
        if (uri != null && !uri.equals("*") && !uri.startsWith("/")) {
            try {
                String scheme = new URI(uri).getScheme();
                if (scheme != null) {
                    return scheme;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.protocol;
    }

    public Enumeration getHeaderEnumeration(String name) {
        Vector<String> values = new Vector<String>();
        for (Header hd : this.getHeaders(name)) {
            values.add(hd.getValue());
        }
        return values.elements();
    }

    private String canonicalize(String url) throws IllegalArgumentException {
        return URLUtil.canonicalize(url);
    }

    private int getCacheControl(String directive, int def) {
        Enumeration headers = this.getHeaderEnumeration("Cache-Control");
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            for (String v : value.split("\\s*,\\s*")) {
                int idx = v.indexOf(61);
                if (idx >= 0 && directive.equals(v.substring(0, idx))) {
                    try {
                        return Integer.parseInt(v.substring(idx + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                if (!directive.equals(v)) continue;
                return Integer.MAX_VALUE;
            }
        }
        return def;
    }
}

