/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import info.aduna.net.ParsedURI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.openrdf.annotations.Header;
import org.openrdf.annotations.HeaderParam;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Method;
import org.openrdf.annotations.Param;
import org.openrdf.annotations.ParameterTypes;
import org.openrdf.annotations.Path;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.InternalServerError;
import org.openrdf.http.object.exceptions.NotAcceptable;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.exceptions.UnsupportedMediaType;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidFactory;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.helpers.ResourceTarget;
import org.openrdf.http.object.util.PathMatcher;
import org.openrdf.http.object.util.URLUtil;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClass {
    private static final Pattern EMPTY_PATTERN = Pattern.compile("");
    private static final Pattern DEFAULT_PATH = PathMatcher.compile("$|\\?.*");
    private static final String SUB_CLASS_OF = "http://www.w3.org/2000/01/rdf-schema#subClassOf";
    private final Logger logger = LoggerFactory.getLogger(ResourceTarget.class);
    private final Map<String, Collection<java.lang.reflect.Method>> methods;
    private final FluidFactory ff = FluidFactory.getInstance();
    private final Class<?> targetClass;

    public ResourceClass(Class<?> targetClass) {
        this.targetClass = targetClass;
        this.methods = new HashMap<String, Collection<java.lang.reflect.Method>>();
        for (java.lang.reflect.Method m : targetClass.getMethods()) {
            Method ann;
            if (m.isAnnotationPresent(ParameterTypes.class) || (ann = m.getAnnotation(Method.class)) == null) continue;
            for (String method : ann.value()) {
                if (!this.methods.containsKey(method)) {
                    this.methods.put(method, new ArrayList(targetClass.getMethods().length));
                }
                this.methods.get(method).add(m);
            }
        }
    }

    public String toString() {
        return this.targetClass.toString();
    }

    public Set<String> getAllowedMethods() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.methods.keySet());
        if (set.contains("GET")) {
            set.add("HEAD");
        }
        return set;
    }

    public Collection<String> getAllowedHeaders(String m, String url, int startingAt) {
        TreeSet<String> result = new TreeSet<String>();
        for (java.lang.reflect.Method method : this.findHandlers(m, url, startingAt)) {
            result.addAll(this.getVaryHeaders(method));
        }
        return result;
    }

    public String getAccept(String req_method, String url, int startingAt) {
        HashSet<String> types = new HashSet<String>();
        for (java.lang.reflect.Method method : this.findHandlers(req_method, url, startingAt)) {
            int n = method.getParameterTypes().length;
            for (int i = 0; i < n; ++i) {
                if (this.getParameterNames(method, i) != null || this.getHeaderNames(method, i) != null) continue;
                for (String media : this.getParameterMediaTypes(method, i)) {
                    if ("*/*".equals(media)) continue;
                    try {
                        MimeType type = new MimeType(media);
                        if ("*".equals(type.getPrimaryType()) && "*".equals(type.getSubType())) continue;
                        type.removeParameter("q");
                        types.add(type.toString());
                    }
                    catch (MimeTypeParseException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (types.isEmpty()) {
            return null;
        }
        String string = ((Object)types).toString();
        return string.substring(1, string.length() - 1);
    }

    public java.lang.reflect.Method getHandlerMethod(String iri, HttpRequest request) throws RepositoryException, ResponseException {
        String url = this.getRequestURL(iri, request);
        if (!url.startsWith(iri)) {
            throw new InternalServerError("URL " + url + " does not start with IRI " + iri);
        }
        return this.findMethod(request, url, iri.length());
    }

    public HttpUriResponse head(String iri, HttpRequest request) throws IOException, HttpException {
        try {
            String url = this.getRequestURL(iri, request);
            if (!url.startsWith(iri)) {
                throw new InternalServerError("URL " + url + " does not start with IRI " + iri);
            }
            java.lang.reflect.Method method = this.findMethod(request, url, iri.length());
            BasicHttpResponse response = new BasicHttpResponse(this.getResponseStatus(method));
            response.setHeaders(this.getAdditionalHeaders(request, method));
            return new HttpUriResponse(url, (HttpResponse)response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    public String[] getHandlerMediaTypes(java.lang.reflect.Method method) {
        org.openrdf.annotations.Type t = method.getAnnotation(org.openrdf.annotations.Type.class);
        if (t == null) {
            return new String[0];
        }
        return t.value();
    }

    public String[] getParameterNames(java.lang.reflect.Method method, int arg) {
        Annotation[] annotations = method.getParameterAnnotations()[arg];
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].annotationType().equals(Param.class)) continue;
            return ((Param)annotations[i]).value();
        }
        return null;
    }

    public String[] getHeaderNames(java.lang.reflect.Method method, int arg) {
        Annotation[] annotations = method.getParameterAnnotations()[arg];
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].annotationType().equals(HeaderParam.class)) continue;
            return ((HeaderParam)annotations[i]).value();
        }
        return null;
    }

    public String[] getParameterMediaTypes(java.lang.reflect.Method method, int arg) {
        Annotation[] annotations = method.getParameterAnnotations()[arg];
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].annotationType().equals(org.openrdf.annotations.Type.class)) continue;
            return ((org.openrdf.annotations.Type)annotations[i]).value();
        }
        return new String[0];
    }

    public Map<String, String> getPathVariables(java.lang.reflect.Method method, String url, int startingAt) {
        Path path = method.getAnnotation(Path.class);
        if (path == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        PathMatcher m = new PathMatcher(url, startingAt);
        for (String regex : path.value()) {
            Map<String, String> match = m.match(regex);
            if (match == null) continue;
            values.putAll(match);
        }
        return values;
    }

    public String getResponseContentType(HttpRequest request, java.lang.reflect.Method method) {
        if (method == null || method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        return this.getContentType(request, method);
    }

    public org.apache.http.Header[] getAdditionalHeaders(HttpRequest request, java.lang.reflect.Method method) {
        String vary;
        if (method == null) {
            return new org.apache.http.Header[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.getAdditionalHeaders(method)));
        String type = this.getResponseContentType(request, method);
        if (type != null) {
            result.add(new BasicHeader("Content-Type", type));
        }
        if ((vary = this.getVaryHeaderValue(method)) != null) {
            result.add(new BasicHeader("Vary", vary));
        }
        return result.toArray(new org.apache.http.Header[result.size()]);
    }

    private String getContentType(HttpRequest request, java.lang.reflect.Method method) {
        Type genericType = method.getGenericReturnType();
        String[] mediaTypes = this.getHandlerMediaTypes(method);
        return this.getFluidBuilder().nil(new FluidType(genericType, mediaTypes)).toMedia(this.getAcceptable(request));
    }

    private String getRequestURL(String iri, HttpRequest request) {
        String uri = request.getRequestLine().getUri();
        if (uri.equals("*")) {
            return "*";
        }
        if (!uri.startsWith("/")) {
            return URLUtil.canonicalize(uri);
        }
        String qs = null;
        int qx = uri.indexOf(63);
        if (qx > 0) {
            qs = uri.substring(qx + 1);
            uri = uri.substring(0, qx);
        }
        ParsedURI base = new ParsedURI(iri);
        String scheme = base.getScheme().toLowerCase();
        String host = base.getAuthority().toLowerCase();
        return URLUtil.canonicalize(new ParsedURI(scheme, host, uri, qs, null).toString());
    }

    private StatusLine getResponseStatus(java.lang.reflect.Method method) {
        if (method == null) {
            return new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 405, "Method Not Allowed");
        }
        Class<?> type = method.getReturnType();
        if (Void.TYPE.equals(type) || Void.class.equals(type)) {
            return new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "No Content");
        }
        return new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
    }

    private org.apache.http.Header[] getAdditionalHeaders(java.lang.reflect.Method method) {
        if (method == null || !method.isAnnotationPresent(Header.class)) {
            return new org.apache.http.Header[0];
        }
        String[] headers = method.getAnnotation(Header.class).value();
        org.apache.http.Header[] result = new org.apache.http.Header[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            String[] split = headers[i].split("\\s*:\\s*", 2);
            result[i] = new BasicHeader(split[0], split[1]);
        }
        return result;
    }

    private String getVaryHeaderValue(java.lang.reflect.Method method) {
        Collection<String> headers = this.getVaryHeaders(method);
        if (headers != null && !headers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String vary : headers) {
                if (vary.length() <= 0 || vary.equalsIgnoreCase("Authorization") || vary.equalsIgnoreCase("Cookie")) continue;
                sb.append(vary).append(',');
            }
            if (sb.length() > 0) {
                return sb.substring(0, sb.length() - 1);
            }
        }
        return null;
    }

    private Collection<String> getVaryHeaders(java.lang.reflect.Method method) {
        if (method == null) {
            return Collections.emptySet();
        }
        TreeSet<String> result = new TreeSet<String>();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] anns;
            for (Annotation ann : anns = annotationArray[i]) {
                if (!ann.annotationType().equals(HeaderParam.class)) continue;
                result.addAll(Arrays.asList(((HeaderParam)ann).value()));
            }
        }
        return result;
    }

    private java.lang.reflect.Method findMethod(HttpRequest request, String url, int startingAt) throws RepositoryException {
        java.lang.reflect.Method method;
        boolean messageBody = this.isMessageBody(request);
        Collection<java.lang.reflect.Method> methods = this.findHandlers(request.getRequestLine().getMethod(), url, startingAt);
        if (!methods.isEmpty() && (method = this.findBestMethod(request, url, startingAt, this.findAcceptableMethods(request, methods, messageBody))) != null) {
            return method;
        }
        return null;
    }

    private boolean isMessageBody(HttpRequest req) {
        org.apache.http.Header length = req.getFirstHeader("Content-Length");
        return length != null && !"0".equals(length.getValue()) || req.containsHeader("Transfer-Encoding");
    }

    private Collection<java.lang.reflect.Method> findHandlers(String req_method, String url, int startingAt) {
        ArrayList<java.lang.reflect.Method> list = new ArrayList<java.lang.reflect.Method>();
        if (req_method == null) {
            for (String m : this.methods.keySet()) {
                list.addAll(this.findHandlers(m, url, startingAt));
            }
        } else {
            Collection<java.lang.reflect.Method> collection = this.methods.get(req_method);
            if (collection == null || collection.isEmpty()) {
                return list;
            }
            for (java.lang.reflect.Method m : collection) {
                if (this.getLongestMatchingPath(m, url, startingAt) == null) continue;
                list.add(m);
            }
        }
        return list;
    }

    private Pattern getLongestMatchingPath(java.lang.reflect.Method method, String url, int startingAt) {
        Path path = method.getAnnotation(Path.class);
        PathMatcher m = new PathMatcher(url, startingAt);
        if (path == null) {
            return m.matches(DEFAULT_PATH) ? EMPTY_PATTERN : null;
        }
        Pattern longest = null;
        for (String regex : path.value()) {
            int llen;
            int rlen;
            Pattern pattern = PathMatcher.compile(regex);
            if (!m.matches(pattern)) continue;
            if (longest == null) {
                longest = pattern;
            }
            if ((rlen = pattern.pattern().length()) <= (llen = longest.pattern().length()) && (rlen != llen || !this.isLiteral(pattern) || this.isLiteral(longest))) continue;
            longest = pattern;
        }
        return longest;
    }

    private boolean isLiteral(Pattern regex) {
        return (regex.flags() & 0x10) != 0;
    }

    private Collection<java.lang.reflect.Method> findAcceptableMethods(HttpRequest request, Collection<java.lang.reflect.Method> methods, boolean messageBody) {
        String readable = null;
        String acceptable = null;
        LinkedHashSet<java.lang.reflect.Method> list = new LinkedHashSet<java.lang.reflect.Method>(methods.size());
        Fluid body = this.getBody(request);
        block0: for (java.lang.reflect.Method method : methods) {
            Collection<String> readableTypes = this.getReadableTypes(body, method, messageBody);
            if (readableTypes.isEmpty()) {
                String contentType = body.getFluidType().preferred();
                Annotation[][] anns = method.getParameterAnnotations();
                for (int i = 0; i < anns.length; ++i) {
                    String[] types = this.getParameterMediaTypes(method, i);
                    Type gtype = method.getGenericParameterTypes()[i];
                    if (body.toMedia(new FluidType(gtype, types)) != null) continue;
                    if (contentType == null) {
                        readable = "Cannot read unknown body into " + gtype + " for " + method.getName();
                        continue block0;
                    }
                    readable = "Cannot read " + contentType + " into " + gtype + " for " + method.getName();
                    continue block0;
                }
                if (readable == null && contentType != null) {
                    readable = "Cannot read " + contentType + " for " + method.getName();
                }
                if (readable != null) continue;
            }
            if (this.isAcceptable(request, method)) {
                list.add(method);
                continue;
            }
            acceptable = "Cannot write " + method.getGenericReturnType() + " for " + method.getName();
        }
        if (list.isEmpty() && readable != null) {
            throw new UnsupportedMediaType(readable);
        }
        if (list.isEmpty() && acceptable != null) {
            throw new NotAcceptable(acceptable);
        }
        return list;
    }

    private Fluid getBody(HttpRequest request) {
        String[] mediaType;
        org.apache.http.Header[] headers = request.getHeaders("Content-Type");
        if (headers == null || headers.length == 0) {
            mediaType = new String[]{"text/plain", "application/octet-stream", "*/*"};
        } else {
            mediaType = new String[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                mediaType[i] = headers[i].getValue();
            }
        }
        FluidType ftype = new FluidType((Type)((Object)HttpEntity.class), mediaType);
        return this.getFluidBuilder().nil(ftype);
    }

    private FluidBuilder getFluidBuilder() {
        return this.ff.builder();
    }

    private boolean isAcceptable(HttpRequest request, java.lang.reflect.Method method) {
        assert (method != null);
        if (method.getReturnType().equals(Void.TYPE)) {
            return true;
        }
        String[] types = this.getHandlerMediaTypes(method);
        Type gtype = method.getGenericReturnType();
        FluidBuilder writer = this.getFluidBuilder();
        if (types.length == 0 && writer.isConsumable(gtype, "message/http")) {
            return true;
        }
        FluidType ftype = new FluidType(gtype, types);
        return writer.isConsumable(ftype) && writer.nil(ftype).toMedia(this.getAcceptable(request)) != null;
    }

    private FluidType getAcceptable(HttpRequest request) {
        org.apache.http.Header[] headers = request.getHeaders("Accept");
        if (headers == null || headers.length == 0) {
            return new FluidType((Type)((Object)HttpEntity.class), new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (org.apache.http.Header hd : headers) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(hd.getValue());
        }
        return new FluidType((Type)((Object)HttpEntity.class), sb.toString().split("\\s*,\\s*"));
    }

    private Collection<String> getReadableTypes(Fluid input, java.lang.reflect.Method method, boolean typeRequired) {
        assert (method != null);
        Class<?>[] ptypes = method.getParameterTypes();
        Object[] args = new Object[ptypes.length];
        if (args.length == 0 && !typeRequired) {
            return Collections.singleton("*/*");
        }
        int empty = 0;
        ArrayList<String> readable = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            Collection<String> set = this.getReadableTypes(input, method, i, typeRequired);
            if (set.isEmpty()) {
                ++empty;
            }
            if (this.getHeaderNames(method, i) != null || this.getParameterNames(method, i) != null) continue;
            readable.addAll(set);
        }
        if (empty > 0 && empty == args.length && typeRequired) {
            return Collections.emptySet();
        }
        if (readable.isEmpty() && !typeRequired) {
            return Collections.singleton("*/*");
        }
        return readable;
    }

    private Collection<String> getReadableTypes(Fluid input, java.lang.reflect.Method method, int i, boolean typeRequired) {
        if (this.getHeaderNames(method, i) != null) {
            return Collections.singleton("*/*");
        }
        if (this.getParameterNames(method, i) != null) {
            return Collections.singleton("*/*");
        }
        ArrayList<String> readable = new ArrayList<String>();
        String[] types = this.getParameterMediaTypes(method, i);
        if (types.length == 0 && typeRequired) {
            return Collections.emptySet();
        }
        String media = input.toMedia(new FluidType(method.getGenericParameterTypes()[i], types));
        if (media != null) {
            readable.add(media);
        }
        return readable;
    }

    private java.lang.reflect.Method findBestMethod(HttpRequest request, String url, int startingAt, Collection<java.lang.reflect.Method> methods) {
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() == 1) {
            return methods.iterator().next();
        }
        Collection<java.lang.reflect.Method> submethods = this.filterSubMethods(methods);
        if (submethods.isEmpty()) {
            return null;
        }
        Collection<java.lang.reflect.Method> longerPath = this.filterLongestPathMethods(submethods, url, startingAt);
        if (longerPath.size() == 1) {
            return longerPath.iterator().next();
        }
        Collection<java.lang.reflect.Method> filtered = this.filterPreferResponseType(request, longerPath);
        if (filtered.size() == 1) {
            return filtered.iterator().next();
        }
        java.lang.reflect.Method best = this.findBestMethodByRequestType(request, filtered);
        if (best == null) {
            return filtered.iterator().next();
        }
        return best;
    }

    private Collection<java.lang.reflect.Method> filterPreferResponseType(HttpRequest request, Collection<java.lang.reflect.Method> methods) {
        FluidType acceptable = this.getAcceptable(request);
        HashSet<java.lang.reflect.Method> filtered = new HashSet<java.lang.reflect.Method>(methods.size());
        double quality = Double.MIN_VALUE;
        for (java.lang.reflect.Method m : methods) {
            if (!m.isAnnotationPresent(org.openrdf.annotations.Type.class)) continue;
            Collection<String> possible = this.getAllMimeTypesOf(m);
            String[] media = possible.toArray(new String[possible.size()]);
            double q = acceptable.as(new FluidType(acceptable.asType(), media)).getQuality();
            if (q > quality) {
                quality = q;
                filtered.clear();
            }
            if (!(q >= quality)) continue;
            filtered.add(m);
        }
        for (java.lang.reflect.Method m : methods) {
            if (m.isAnnotationPresent(org.openrdf.annotations.Type.class)) continue;
            filtered.add(m);
        }
        return filtered;
    }

    private Collection<String> getAllMimeTypesOf(java.lang.reflect.Method m) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (m.isAnnotationPresent(org.openrdf.annotations.Type.class)) {
            for (String media : m.getAnnotation(org.openrdf.annotations.Type.class).value()) {
                result.add(media);
            }
        }
        if (result.isEmpty()) {
            result.add("*/*");
        }
        return result;
    }

    private Collection<java.lang.reflect.Method> filterSubMethods(Collection<java.lang.reflect.Method> methods) {
        LinkedHashMap<String, java.lang.reflect.Method> map = new LinkedHashMap<String, java.lang.reflect.Method>();
        for (java.lang.reflect.Method m : methods) {
            Iri ann = m.getAnnotation(Iri.class);
            String iri = ann == null ? m.toString() : ann.value();
            map.put(iri, m);
        }
        for (java.lang.reflect.Method method : methods) {
            for (String iri : this.getAnnotationStringValue(method, SUB_CLASS_OF)) {
                map.remove(iri);
            }
        }
        if (map.isEmpty()) {
            return methods;
        }
        return map.values();
    }

    private String[] getAnnotationStringValue(java.lang.reflect.Method method, String iri) {
        for (Annotation ann : method.getAnnotations()) {
            for (java.lang.reflect.Method field : ann.annotationType().getMethods()) {
                Iri airi = field.getAnnotation(Iri.class);
                if (airi == null || !iri.equals(airi.value())) continue;
                try {
                    Object arg = field.invoke((Object)ann, new Object[0]);
                    if (arg instanceof String[]) {
                        return (String[])arg;
                    }
                    return new String[]{arg.toString()};
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn(e.toString(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    this.logger.warn(e.toString(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.logger.warn(e.toString(), (Throwable)e);
                }
            }
        }
        return new String[0];
    }

    private Collection<java.lang.reflect.Method> filterLongestPathMethods(Collection<java.lang.reflect.Method> methods, String url, int startingAt) {
        int length = -1;
        Pattern longest = null;
        ArrayList<java.lang.reflect.Method> result = new ArrayList<java.lang.reflect.Method>(methods.size());
        for (java.lang.reflect.Method m : methods) {
            int len;
            Pattern path = this.getLongestMatchingPath(m, url, startingAt);
            int n = len = path == null ? -1 : path.pattern().length();
            if (len > length || len == length && path != null && this.isLiteral(path) && !this.isLiteral(longest)) {
                result.clear();
                longest = path;
                length = len;
            }
            if (len < length || path != null && !this.isLiteral(path) && this.isLiteral(longest)) continue;
            result.add(m);
        }
        return result;
    }

    private java.lang.reflect.Method findBestMethodByRequestType(HttpRequest request, Collection<java.lang.reflect.Method> methods) {
        java.lang.reflect.Method best = null;
        double quality = Double.MIN_VALUE;
        Fluid body = this.getBody(request);
        for (java.lang.reflect.Method method : methods) {
            Type[] gtypes = method.getGenericParameterTypes();
            int n = method.getParameterTypes().length;
            for (int i = 0; i < n; ++i) {
                FluidType fluidType;
                double q;
                String[] types;
                Type gtype = gtypes[i];
                if (this.getHeaderNames(method, i) != null || this.getParameterNames(method, i) != null || (types = this.getParameterMediaTypes(method, i)).length == 0 || !((q = (fluidType = new FluidType(gtype, types)).as(body.getFluidType()).getQuality()) > quality)) continue;
                quality = q;
                best = method;
            }
        }
        return best;
    }
}

