/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.HttpUriEntity;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.InternalServerError;
import org.openrdf.http.object.exceptions.MethodNotAllowed;
import org.openrdf.http.object.exceptions.NotFound;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.fluid.Fluid;
import org.openrdf.http.object.fluid.FluidBuilder;
import org.openrdf.http.object.fluid.FluidException;
import org.openrdf.http.object.fluid.FluidFactory;
import org.openrdf.http.object.fluid.FluidType;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResourceClass;
import org.openrdf.http.object.helpers.ResponseBuilder;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.object.ObjectConnection;
import org.openrdf.repository.object.RDFObject;
import org.openrdf.repository.object.traits.RDFObjectBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTarget {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Logger logger = LoggerFactory.getLogger(ResourceTarget.class);
    private final FluidFactory ff = FluidFactory.getInstance();
    private final ResourceClass rClass;
    private final ObjectContext context;
    private final ValueFactory vf;
    private final ObjectConnection con;
    private RDFObject target;
    private final FluidBuilder writer;

    public ResourceTarget(ResourceClass rClass, RDFObject target, HttpContext context) {
        this.rClass = rClass;
        this.target = target;
        this.context = ObjectContext.adapt(context);
        this.con = target.getObjectConnection();
        this.vf = this.con.getValueFactory();
        this.writer = this.ff.builder();
    }

    public String toString() {
        return this.target.toString();
    }

    public RDFObject getTargetObject() {
        return this.target;
    }

    public Set<String> getAllowedMethods(String url) {
        return this.rClass.getAllowedMethods();
    }

    public Collection<String> getAllowedHeaders(String m, String url) {
        String iri = this.target.getResource().stringValue();
        if (!url.startsWith(iri)) {
            throw new InternalServerError("URL " + url + " does not start with IRI " + iri);
        }
        return this.rClass.getAllowedHeaders(m, url, iri.length());
    }

    public String getAccept(String req_method, String url) {
        String iri = this.target.getResource().stringValue();
        if (!url.startsWith(iri)) {
            throw new InternalServerError("URL " + url + " does not start with IRI " + iri);
        }
        return this.rClass.getAccept(req_method, url, iri.length());
    }

    public Method getHandlerMethod(HttpRequest request) {
        try {
            return this.rClass.getHandlerMethod(this.target.getResource().stringValue(), request);
        }
        catch (RepositoryException e) {
            throw new InternalServerError(e);
        }
        catch (ResponseException e) {
            return null;
        }
    }

    public HttpUriResponse head(HttpRequest request) throws IOException, HttpException {
        return this.rClass.head(this.target.getResource().stringValue(), request);
    }

    public HttpUriResponse invoke(HttpRequest request) throws IOException, HttpException {
        try {
            Request req = new Request(request, this.context);
            String iri = this.target.getResource().stringValue();
            Method method = this.rClass.getHandlerMethod(iri, (HttpRequest)req);
            if (method == null && req.isSafe()) {
                throw new NotFound("Not Found: " + req.getRequestURL());
            }
            if (method == null) {
                throw new MethodNotAllowed("No such method for " + req.getRequestURL());
            }
            HttpUriResponse resp = this.invoke(req, method, req.isSafe(), new ResponseBuilder(req));
            for (Header hd : this.rClass.getAdditionalHeaders(request, method)) {
                HttpUriEntity entity = resp.getEntity();
                if (entity != null && ("Content-Encoding".equalsIgnoreCase(hd.getName()) && entity.getContentEncoding() != null || "Content-Length".equalsIgnoreCase(hd.getName()) && entity.getContentLength() >= 0L || "Content-Type".equalsIgnoreCase(hd.getName()) && entity.getContentType() != null) || resp.containsHeader(hd.getName())) continue;
                resp.addHeader(hd);
            }
            return resp;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerError(e);
        }
    }

    private Fluid getBody(Request request) {
        String[] mediaType;
        Header[] headers = request.getHeaders("Content-Type");
        if (headers == null || headers.length == 0) {
            mediaType = new String[]{"text/plain", "application/octet-stream", "*/*"};
        } else {
            mediaType = new String[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                mediaType[i] = headers[i].getValue();
            }
        }
        String location = request.getResolvedHeader("Content-Location");
        location = location == null ? request.getRequestURL() : this.createURI(request, location).stringValue();
        FluidType ftype = new FluidType((Type)((Object)HttpEntity.class), mediaType);
        return this.writer.consume(request.getEntity(), location, ftype);
    }

    private URI createURI(Request request, String uriSpec) {
        return this.vf.createURI(request.resolve(uriSpec));
    }

    private RDFObject getRequestedResource() {
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpUriResponse invoke(Request req, Method method, boolean safe, ResponseBuilder builder) throws Exception {
        Fluid body = this.getBody(req);
        try {
            HttpUriResponse httpUriResponse;
            Object[] args;
            try {
                args = this.getParameters(req, method, body);
            }
            catch (ParserConfigurationException e) {
                throw e;
            }
            catch (TransformerConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.toString();
                }
                HttpUriResponse httpUriResponse2 = builder.badRequest(message);
                if (body != null) {
                    try {
                        body.asVoid();
                    }
                    catch (IOException e2) {
                        this.logger.error(req.toString(), (Throwable)e2);
                    }
                }
                return httpUriResponse2;
            }
            try {
                HttpUriResponse response = this.invoke(req, method, args, builder);
                if (!safe && response.getStatusLine().getStatusCode() < 400) {
                    this.flush();
                }
                httpUriResponse = response;
            }
            catch (Throwable throwable) {
                try {
                    for (Object arg : args) {
                        if (!(arg instanceof Closeable)) continue;
                        ((Closeable)arg).close();
                    }
                    throw throwable;
                }
                catch (InvocationTargetException e) {
                    try {
                        throw e.getCause();
                    }
                    catch (Error cause) {
                        throw cause;
                    }
                    catch (Exception cause) {
                        throw cause;
                    }
                    catch (Throwable cause) {
                        throw e;
                    }
                }
            }
            for (Object arg : args) {
                if (!(arg instanceof Closeable)) continue;
                ((Closeable)arg).close();
            }
            return httpUriResponse;
        }
        finally {
            if (body != null) {
                try {
                    body.asVoid();
                }
                catch (IOException e) {
                    this.logger.error(req.toString(), (Throwable)e);
                }
            }
        }
    }

    private void flush() throws RepositoryException, QueryEvaluationException, IOException {
        this.con.commit();
        this.target = (RDFObject)this.con.getObject(RDFObject.class, this.getRequestedResource().getResource());
    }

    private Object[] getParameters(Request req, Method method, Fluid input) throws Exception {
        Class<?>[] ptypes = method.getParameterTypes();
        Type[] gtypes = method.getGenericParameterTypes();
        String iri = this.target.getResource().stringValue();
        Map<String, String> values = this.rClass.getPathVariables(method, req.getRequestURL(), iri.length());
        Object[] args = new Object[ptypes.length];
        for (int i = 0; i < args.length; ++i) {
            Fluid entity = this.getParameter(req, method, i, values, input);
            if (entity == null) continue;
            String[] types = this.rClass.getParameterMediaTypes(method, i);
            args[i] = entity.as(new FluidType(gtypes[i], types));
        }
        return args;
    }

    private Fluid getParameter(Request req, Method method, int i, Map<String, String> values, Fluid input) throws Exception {
        String[] names = this.rClass.getParameterNames(method, i);
        String[] headers = this.rClass.getHeaderNames(method, i);
        String[] types = this.rClass.getParameterMediaTypes(method, i);
        if (names == null && headers == null && types.length == 0) {
            return this.writer.media("*/*");
        }
        if (names == null && headers == null) {
            return input;
        }
        if (headers != null && names != null) {
            return this.getHeaderAndQuery(req, headers, names, values);
        }
        if (headers != null) {
            return this.getHeader(req, headers);
        }
        return this.getParameter(req, names, values);
    }

    private Fluid getHeaderAndQuery(Request req, String[] headers, String[] queries, Map<String, String> values) {
        String[] qvalues = this.getParameterValues(req, queries, values);
        if (qvalues == null) {
            return this.getHeader(req, headers);
        }
        ArrayList<String> list = new ArrayList<String>(qvalues.length * 2);
        if (qvalues.length > 0) {
            list.addAll(Arrays.asList(qvalues));
        }
        for (String name : headers) {
            for (Header header : req.getHeaders(name)) {
                list.add(header.getValue());
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        FluidType ftype = new FluidType((Type)((Object)String[].class), "text/plain", "text/*");
        FluidBuilder fb = this.writer;
        return fb.consume(array, req.getIRI(), ftype);
    }

    private String[] getParameterValues(Request req, String[] names, Map<String, String> values) {
        if (names.length == 0) {
            return new String[0];
        }
        Map<String, String[]> map = this.getParameterMap(req);
        ArrayList<Object> list = new ArrayList<Object>(names.length * 2);
        for (String name : names) {
            if (values.containsKey(name)) {
                if (values.get(name) == null) continue;
                list.add(values.get(name));
                continue;
            }
            if (map == null || !map.containsKey(name)) continue;
            list.addAll(Arrays.asList((Object[])map.get(name)));
        }
        return list.toArray(new String[list.size()]);
    }

    private Map<String, String[]> getParameterMap(Request req) {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        String uri = req.getRequestLine().getUri();
        int q = uri.indexOf(63);
        if (q < 0) {
            return Collections.emptyMap();
        }
        String qs = uri.substring(q + 1);
        for (NameValuePair pair : URLEncodedUtils.parse((String)qs, (Charset)UTF8)) {
            if (map.containsKey(pair.getName())) {
                String[] previous = (String[])map.get(pair.getName());
                String[] values = new String[previous.length + 1];
                System.arraycopy(previous, 0, values, 0, previous.length);
                values[previous.length] = pair.getValue();
                map.put(pair.getName(), values);
                continue;
            }
            map.put(pair.getName(), new String[]{pair.getValue()});
        }
        return map;
    }

    private Fluid getHeader(Request request, String ... names) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            for (Header header : request.getHeaders(name)) {
                list.add(header.getValue());
            }
        }
        String[] values = list.toArray(new String[list.size()]);
        FluidType ftype = new FluidType((Type)((Object)String[].class), "text/plain", "text/*", "*/*");
        FluidBuilder fb = FluidFactory.getInstance().builder();
        return fb.consume(values, request.getIRI(), ftype);
    }

    private Fluid getParameter(Request req, String[] names, Map<String, String> values) {
        String[] array = this.getParameterValues(req, names, values);
        FluidType ftype = new FluidType((Type)((Object)String[].class), "text/plain", "text/*", "*/*");
        FluidBuilder fb = this.writer;
        return fb.consume(array, req.getIRI(), ftype);
    }

    private HttpUriResponse invoke(Request req, Method method, Object[] args, ResponseBuilder rbuilder) throws Exception {
        Object result = method.invoke((Object)this.getRequestedResource(), args);
        if (result instanceof RDFObjectBehaviour) {
            result = ((RDFObjectBehaviour)result).getBehaviourDelegate();
        }
        return new HttpUriResponse(req.getRequestURL(), this.createResponse(req, result, method, this.rClass.getHandlerMediaTypes(method), rbuilder));
    }

    private HttpResponse createResponse(Request req, Object result, Method method, String[] responseTypes, ResponseBuilder rbuilder) throws IOException, FluidException {
        FluidBuilder builder = this.writer;
        Type gtype = method.getGenericReturnType();
        if (!method.isAnnotationPresent(org.openrdf.annotations.Type.class) && builder.isConsumable(gtype, "message/http")) {
            Fluid writer = builder.consume(result, req.getRequestURL(), gtype, "message/http");
            HttpResponse http = writer.asHttpResponse("message/http");
            if (http == null) {
                return rbuilder.noContent(204, "No Content");
            }
            return http;
        }
        Class<?> type = method.getReturnType();
        if (result == null || Set.class.equals(type) && ((Set)result).isEmpty()) {
            return rbuilder.noContent(204, "No Content");
        }
        Fluid writer = builder.consume(result, req.getRequestURL(), gtype, responseTypes);
        HttpEntity entity = writer.asHttpEntity(this.rClass.getResponseContentType((HttpRequest)req, method));
        return rbuilder.content(200, "OK", entity);
    }
}

