/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.client.HttpUriResponse;
import org.openrdf.http.object.exceptions.ResponseException;
import org.openrdf.http.object.helpers.EntityRemovedHttpResponse;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.ReadableHttpEntityChannel;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.io.ChannelUtil;

public class ResponseBuilder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final StatusLine _200 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
    private static final StatusLine _204 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "No Content");
    private static final StatusLine _302 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Found");
    private static final StatusLine _303 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 303, "See Other");
    private static final StatusLine _304 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 304, "Not Modified");
    private static final StatusLine _404 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 404, "Not Found");
    private static final StatusLine _412 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 412, "Precondition Failed");
    static final StatusLine _500 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "Internal Server Error");
    private static final Pattern URL_PATTERN = Pattern.compile("[a-zA-Z0-9\\+\\-\\.]+://[a-zA-Z0-9\\-\\._~%!\\$\\&'\\(\\)\\*\\+,;=:/\\?\\#\\[\\]@]+");
    private final String systemId;

    public ResponseBuilder(HttpRequest request, HttpContext context) {
        this(new Request(request, ObjectContext.adapt(context)));
    }

    public ResponseBuilder(Request request) {
        this(request.getRequestURL());
    }

    public ResponseBuilder(String systemId) {
        this.systemId = systemId;
    }

    public HttpUriResponse ok(HttpEntity entity) {
        BasicHttpResponse response = new BasicHttpResponse(_200);
        response.setEntity(entity);
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse noContent() {
        BasicHttpResponse response = new BasicHttpResponse(_204);
        response.setHeader("Content-Length", "0");
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse found(String location) {
        BasicHttpResponse response = new BasicHttpResponse(_302);
        response.addHeader("Location", location);
        response.setEntity((HttpEntity)new StringEntity(location, ContentType.create((String)"text/uri-list", (Charset)UTF8)));
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse see(String location) {
        BasicHttpResponse response = new BasicHttpResponse(_303);
        response.addHeader("Location", location);
        response.setEntity((HttpEntity)new StringEntity(location, ContentType.create((String)"text/uri-list", (Charset)UTF8)));
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse notModified() {
        BasicHttpResponse response = new BasicHttpResponse(_304);
        response.setHeader("Content-Length", "0");
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse badRequest(String message) {
        BasicStatusLine status = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 400, message);
        EntityRemovedHttpResponse response = new EntityRemovedHttpResponse((StatusLine)status);
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        byte[] body = this.formatPage(this.createPage(message));
        response.setHeader("Content-Length", String.valueOf(body.length));
        ReadableByteChannel in = ChannelUtil.newChannel(body);
        response.setEntity(new ReadableHttpEntityChannel("text/html;charset=UTF-8", body.length, in));
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse notFound(String url) {
        EntityRemovedHttpResponse response = new EntityRemovedHttpResponse(_404);
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        byte[] body = this.formatPage(this.createPage("Not Found: " + url));
        response.setHeader("Content-Length", String.valueOf(body.length));
        ReadableByteChannel in = ChannelUtil.newChannel(body);
        response.setEntity(new ReadableHttpEntityChannel("text/html;charset=UTF-8", body.length, in));
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse preconditionFailed() {
        BasicHttpResponse response = new BasicHttpResponse(_412);
        response.setHeader("Content-Length", "0");
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse preconditionFailed(String phrase) {
        BasicStatusLine status = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 412, phrase);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)status);
        response.setHeader("Content-Length", "0");
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse serverError() {
        BasicHttpResponse response = new BasicHttpResponse(_500);
        response.setHeader("Content-Type", "text/html;charset=UTF-8");
        byte[] body = this.formatPage(this.createPage("Internal Server Error"));
        response.setHeader("Content-Length", String.valueOf(body.length));
        ReadableByteChannel in = ChannelUtil.newChannel(body);
        response.setEntity((HttpEntity)new ReadableHttpEntityChannel("text/html;charset=UTF-8", body.length, in));
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse noContent(int code, String phrase) {
        BasicStatusLine status = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, code, phrase);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)status);
        response.setHeader("Content-Length", "0");
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse content(int code, String phrase, HttpEntity entity) {
        BasicStatusLine status = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, code, phrase);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)status);
        response.setEntity(entity);
        return this.respond((HttpResponse)response);
    }

    public HttpUriResponse respond(HttpResponse response) {
        if (response instanceof HttpUriResponse) {
            return (HttpUriResponse)response;
        }
        return new HttpUriResponse(this.systemId, response);
    }

    public HttpUriResponse exception(ResponseException exception) {
        HttpVersion ver = HttpVersion.HTTP_1_1;
        int code = exception.getStatusCode();
        String phrase = exception.getShortMessage();
        EntityRemovedHttpResponse response = new EntityRemovedHttpResponse((ProtocolVersion)ver, code, phrase);
        String type = "text/html;charset=UTF-8";
        response.setHeader("Content-Type", type);
        for (Header hd : exception.getResponseHeaders()) {
            response.addHeader(hd);
        }
        byte[] body = this.formatPage(this.createErrorPage(exception));
        response.setHeader("Content-Length", String.valueOf(body.length));
        ReadableByteChannel in = ChannelUtil.newChannel(body);
        ReadableHttpEntityChannel entity = new ReadableHttpEntityChannel(type, body.length, in);
        response.setEntity(entity);
        return this.respond((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createErrorPage(ResponseException exception) {
        StringWriter writer = new StringWriter();
        PrintWriter print = new PrintWriter(writer);
        try {
            print.append("<html xmlns='http://www.w3.org/1999/xhtml'>\n");
            print.append("<head><title>");
            print.append(this.enc(exception.getLongMessage()));
            print.append("</title></head>\n");
            print.append("<body>\n");
            print.append("<div class='container'>\n");
            print.append("<h1 class='text-error'>");
            print.append(this.html(exception.getLongMessage()));
            print.append("</h1>\n");
            if (exception.getCause() != null) {
                print.append("<pre class='text-error'>");
                StringWriter sw = new StringWriter();
                PrintWriter print1 = new PrintWriter(sw);
                exception.printStackTrace(print1);
                print1.close();
                print.append(this.enc(((Object)sw).toString()));
                print.append("</pre>\n");
            } else if (exception.getStatusCode() >= 500) {
                print.append("<pre class='text-error'>");
                print.append(this.enc(exception.getDetailMessage()));
                print.append("</pre>\n");
            }
            print.append("</div>\n");
            print.append("</body>\n");
            print.append("</html>\n");
        }
        finally {
            print.close();
        }
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createPage(String title) {
        StringWriter writer = new StringWriter();
        PrintWriter print = new PrintWriter(writer);
        try {
            print.append("<html xmlns='http://www.w3.org/1999/xhtml'>\n");
            print.append("<head><title>");
            print.append(this.enc(title));
            print.append("</title></head>\n");
            print.append("<body>\n");
            print.append("<div class='container'>\n");
            print.append("<h1 class='text-error'>");
            print.append(this.html(title));
            print.append("</h1>\n");
            print.append("</div>\n");
            print.append("</body>\n");
            print.append("</html>\n");
        }
        finally {
            print.close();
        }
        return ((Object)writer).toString();
    }

    private String html(String string) {
        if (string.contains("://")) {
            int end = 0;
            StringBuilder sb = new StringBuilder();
            Matcher m = URL_PATTERN.matcher(string);
            while (m.find()) {
                String url = m.group();
                sb.append(this.enc(string.substring(end, m.start())));
                sb.append("<a href=\"").append(this.enc(url)).append("\">");
                int path = url.indexOf(47, url.indexOf("://") + 3);
                String label = path > 0 ? url.substring(path) : url;
                sb.append(this.enc(label));
                sb.append("</a>");
                end = m.end();
            }
            sb.append(this.enc(string.substring(end, string.length())));
            return sb.toString();
        }
        return this.enc(string);
    }

    private String enc(String string) {
        String result = string.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        return result;
    }

    private byte[] formatPage(String body) {
        return body.getBytes(UTF8);
    }
}

