/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

public class StagedFuture
implements Future<HttpResponse>,
FutureCallback<HttpResponse> {
    private final FutureCallback<HttpResponse> callback;
    private final List<Future<?>> stages = new ArrayList(4);
    private volatile boolean done;
    private HttpResponse result;
    private Throwable thrown;

    public StagedFuture(FutureCallback<HttpResponse> callback) {
        this.callback = callback;
    }

    public String toString() {
        return String.valueOf(this.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStage(Future<?> stage) {
        Object object = this.stages;
        synchronized (object) {
            this.stages.add(stage);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        List<Future<?>> list = this.stages;
        synchronized (list) {
            for (Future<?> stage : this.stages) {
                if (!stage.isCancelled()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        List<Future<?>> list = this.stages;
        synchronized (list) {
            for (Future<?> stage : this.stages) {
                if (stage.isDone()) continue;
                return false;
            }
        }
        return this.done;
    }

    @Override
    public HttpResponse get() throws InterruptedException, ExecutionException {
        this.waitUntilDone();
        if (this.thrown != null) {
            throw new ExecutionException(this.thrown);
        }
        return this.result;
    }

    @Override
    public HttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitUntilDone(timeout, unit);
        if (this.thrown != null) {
            throw new ExecutionException(this.thrown);
        }
        return this.result;
    }

    public void completed(HttpResponse result) {
        try {
            this.result = result;
            if (this.callback != null) {
                this.callback.completed((Object)result);
            }
        }
        finally {
            this.done();
        }
    }

    public void failed(Exception exception) {
        try {
            this.thrown = exception;
            if (this.callback != null) {
                this.callback.failed(exception);
            }
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean cancelled = true;
            List<Future<?>> list = this.stages;
            synchronized (list) {
                for (Future<?> stage : this.stages) {
                    cancelled &= stage.cancel(mayInterruptIfRunning);
                }
            }
            if (this.callback != null) {
                this.callback.cancelled();
            }
            boolean bl = cancelled;
            return bl;
        }
        finally {
            this.done();
        }
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    public void cancelled() {
        try {
            if (this.callback != null) {
                this.callback.cancelled();
            }
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<?> getCurrentStage() {
        List<Future<?>> list = this.stages;
        synchronized (list) {
            for (Future<?> stage : this.stages) {
                if (stage.isDone()) continue;
                return stage;
            }
        }
        return null;
    }

    private synchronized void done() {
        if (!this.done) {
            this.done = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDone() throws InterruptedException, ExecutionException {
        Future<?> stage = this.getCurrentStage();
        if (stage == null && !this.done) {
            StagedFuture stagedFuture = this;
            synchronized (stagedFuture) {
                if (!this.done) {
                    this.wait();
                }
            }
            this.waitUntilDone();
        } else if (stage != null) {
            stage.get();
            this.waitUntilDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDone(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long msecs = unit.toMillis(timeout);
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        Future<?> stage = this.getCurrentStage();
        if (stage == null && !this.done) {
            StagedFuture stagedFuture = this;
            synchronized (stagedFuture) {
                if (!this.done) {
                    this.wait(waitTime);
                }
            }
            waitTime = msecs - (System.currentTimeMillis() - startTime);
            if (!this.done && waitTime <= 0L) {
                throw new TimeoutException();
            }
            this.waitUntilDone(waitTime, TimeUnit.MILLISECONDS);
        } else if (stage != null) {
            stage.get(waitTime, TimeUnit.MILLISECONDS);
            waitTime = msecs - (System.currentTimeMillis() - startTime);
            if (!this.done && waitTime <= 0L) {
                throw new TimeoutException();
            }
            this.waitUntilDone(waitTime, TimeUnit.MILLISECONDS);
        }
    }
}

