/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.WriterConfig;

public class ArrangedWriter
implements RDFWriter {
    private static int MAX_QUEUE_SIZE = 100;
    private final RDFWriter delegate;
    private int queueSize = 0;
    private final Deque<Resource> stack = new LinkedList<Resource>();
    private final Map<String, String> prefixes = new TreeMap<String, String>();
    private final Map<Resource, Set<Statement>> statements = new LinkedHashMap<Resource, Set<Statement>>();
    private final Comparator<Statement> comparator = new Comparator<Statement>(){

        @Override
        public int compare(Statement s1, Statement s2) {
            URI p1 = s1.getPredicate();
            URI p2 = s2.getPredicate();
            if (p1.equals((Object)RDF.TYPE) && !p2.equals((Object)RDF.TYPE)) {
                return -1;
            }
            if (!p1.equals((Object)RDF.TYPE) && p2.equals((Object)RDF.TYPE)) {
                return 1;
            }
            Value o1 = s1.getObject();
            Value o2 = s2.getObject();
            if (!(o1 instanceof BNode) && o2 instanceof BNode) {
                return -1;
            }
            if (o1 instanceof BNode && !(o2 instanceof BNode)) {
                return 1;
            }
            if (!(o1 instanceof URI) && o2 instanceof URI) {
                return -1;
            }
            if (o1 instanceof URI && !(o2 instanceof URI)) {
                return 1;
            }
            int cmp = p1.stringValue().compareTo(p2.stringValue());
            if (cmp != 0) {
                return cmp;
            }
            return o1.stringValue().compareTo(o2.stringValue());
        }
    };

    public ArrangedWriter(RDFWriter delegate) {
        this.delegate = delegate;
    }

    public void setWriterConfig(WriterConfig config) {
        this.delegate.setWriterConfig(config);
    }

    public WriterConfig getWriterConfig() {
        return this.delegate.getWriterConfig();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return this.delegate.getSupportedSettings();
    }

    public RDFFormat getRDFFormat() {
        return this.delegate.getRDFFormat();
    }

    public void startRDF() throws RDFHandlerException {
        this.delegate.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.trimNamespaces();
        this.flushStatements();
        this.delegate.endRDF();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.flushStatements();
        if (!this.prefixes.containsKey(uri)) {
            this.prefixes.put(uri, prefix);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.flushStatements();
        this.delegate.handleComment(comment);
    }

    public synchronized void handleStatement(Statement st) throws RDFHandlerException {
        this.store(st);
        while (this.queueSize > MAX_QUEUE_SIZE) {
            this.flushNamespaces();
            this.delegate.handleStatement(this.nextStatement());
        }
    }

    private synchronized Statement nextStatement() {
        Value obj;
        if (this.statements.isEmpty()) {
            return null;
        }
        Iterator<Statement> set = null;
        while (set == null) {
            Set<Statement> stmts = this.statements.get(this.stack.peekLast());
            if (stmts == null) {
                this.stack.pollLast();
            } else {
                set = stmts.iterator();
            }
            if (!this.stack.isEmpty()) continue;
            set = this.statements.values().iterator().next().iterator();
        }
        Statement next = (Statement)set.next();
        --this.queueSize;
        set.remove();
        if (set.hasNext()) {
            if (!next.getSubject().equals(this.stack.peekLast())) {
                this.stack.addLast(next.getSubject());
            }
        } else {
            this.statements.remove(next.getSubject());
        }
        if ((obj = next.getObject()) instanceof BNode && this.statements.containsKey(obj)) {
            this.stack.addLast((Resource)((BNode)obj));
        }
        return next;
    }

    private synchronized void store(Statement st) {
        Set<Statement> set = this.statements.get(st.getSubject());
        if (set == null) {
            set = new TreeSet<Statement>(this.comparator);
            this.statements.put(st.getSubject(), set);
        }
        set.add(st);
        ++this.queueSize;
    }

    private synchronized void flushStatements() throws RDFHandlerException {
        if (!this.statements.isEmpty()) {
            Statement st;
            this.flushNamespaces();
            while ((st = this.nextStatement()) != null) {
                this.delegate.handleStatement(st);
            }
            this.queueSize = 0;
        }
    }

    private synchronized void flushNamespaces() throws RDFHandlerException {
        TreeMap<String, String> namespaces = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            namespaces.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            this.delegate.handleNamespace(entry.getKey(), entry.getValue());
        }
        this.prefixes.clear();
    }

    private synchronized void trimNamespaces() {
        if (!this.prefixes.isEmpty()) {
            HashSet<String> used = new HashSet<String>(this.prefixes.size());
            for (Set<Statement> set : this.statements.values()) {
                for (Statement st : set) {
                    Literal lit;
                    used.add(st.getPredicate().getNamespace());
                    if (st.getObject() instanceof URI) {
                        URI uri = (URI)st.getObject();
                        used.add(uri.getNamespace());
                        continue;
                    }
                    if (!(st.getObject() instanceof Literal) || (lit = (Literal)st.getObject()).getDatatype() == null) continue;
                    used.add(lit.getDatatype().getNamespace());
                }
            }
            this.prefixes.keySet().retainAll(used);
        }
    }
}

