/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class AsyncPipe {
    private static final int CAPACITY_TIMEOUT = 10000;
    private final ByteBuffer buf;
    private Throwable error;
    private boolean closed;
    private Runnable action;
    boolean stale;
    long expiresAt;

    public AsyncPipe() {
        this(65536);
    }

    public AsyncPipe(int capacity) {
        this.buf = ByteBuffer.allocate(capacity);
        this.resetTimeout();
    }

    public synchronized boolean isOpen() {
        return !this.closed;
    }

    public synchronized boolean isStale() {
        return this.stale;
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
        this.capacityAvailable();
    }

    public synchronized void fail(Throwable e) {
        this.error = e;
        this.close();
    }

    public synchronized boolean hasAvailableCapacity() {
        if (this.closed || this.buf.hasRemaining()) {
            return true;
        }
        try {
            this.wait(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.closed || this.buf.hasRemaining();
    }

    public synchronized void onAvailableCapacity(Runnable action) {
        if (this.closed || this.buf.hasRemaining()) {
            action.run();
        } else {
            this.action = action;
        }
    }

    public synchronized int sink(ReadableByteChannel in) throws IOException {
        if (this.closed) {
            this.buf.clear();
        }
        try {
            int n = in.read(this.buf);
            return n;
        }
        catch (Error e) {
            this.fail(e);
            throw e;
        }
        catch (IOException e) {
            this.fail(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.fail(e);
            throw e;
        }
        finally {
            this.notifyAll();
        }
    }

    public synchronized ReadableByteChannel source() {
        return new ReadableByteChannel(){
            private boolean closed;

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
                AsyncPipe.this.abort();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(final ByteBuffer dst) throws IOException {
                AsyncPipe asyncPipe = AsyncPipe.this;
                synchronized (asyncPipe) {
                    int n = 0;
                    while (n == 0 && dst.hasRemaining()) {
                        n = AsyncPipe.this.source(new Source(){

                            @Override
                            public int write(ByteBuffer src) throws IOException {
                                return this.copy(src, dst);
                            }
                        });
                        if (!dst.hasRemaining()) {
                            AsyncPipe.this.resetTimeout();
                            continue;
                        }
                        if (n != 0) continue;
                        try {
                            long timeout = AsyncPipe.this.expiresAt - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                AsyncPipe.this.stale = true;
                                this.close();
                                throw new InterruptedIOException("Read timeout");
                            }
                            AsyncPipe.this.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            InterruptedIOException ie = new InterruptedIOException(e.toString());
                            ie.initCause(e);
                            throw ie;
                        }
                    }
                    return n;
                }
            }

            int copy(ByteBuffer src, ByteBuffer dst) {
                int limit;
                int n = src.remaining();
                if (n <= (limit = dst.remaining())) {
                    dst.put(src);
                } else {
                    n = limit;
                    for (int i = 0; i < n; ++i) {
                        dst.put(src.get());
                    }
                }
                return n;
            }
        };
    }

    synchronized void abort() {
        this.close();
        this.buf.clear();
        this.capacityAvailable();
    }

    synchronized int source(WritableByteChannel out) throws IOException {
        if (this.error != null) {
            try {
                throw new IOException(this.error);
            }
            catch (Throwable throwable) {
                this.error = null;
                throw throwable;
            }
        }
        if (this.closed && this.buf.position() == 0) {
            return -1;
        }
        this.buf.flip();
        int n = out.write(this.buf);
        this.buf.compact();
        if (this.buf.remaining() >= this.buf.capacity() / 2) {
            this.capacityAvailable();
        }
        return n;
    }

    synchronized void resetTimeout() {
        this.expiresAt = System.currentTimeMillis() + 10000L;
    }

    private synchronized void capacityAvailable() {
        if (this.action != null) {
            try {
                this.action.run();
            }
            finally {
                this.action = null;
            }
        }
    }

    static abstract class Source
    implements WritableByteChannel {
        private boolean closed;

        Source() {
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }

    public static abstract class Sink
    implements ReadableByteChannel {
        private boolean closed;

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

