/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class AutoCloseChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private boolean closed;

    public AutoCloseChannel(ReadableByteChannel delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        if (this.closed) {
            return -1;
        }
        int read = this.delegate.read(dst);
        if (read < 0) {
            this.closed = true;
            this.close();
        }
        return read;
    }
}

