/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Queue;
import org.openrdf.http.object.io.ChannelUtil;

public class CatReadableByteChannel
implements ReadableByteChannel {
    private Queue<ReadableByteChannel> queue = new LinkedList<ReadableByteChannel>();
    private boolean closed;
    private ByteArrayOutputStream out;
    private OutputStreamWriter writer;

    public String toString() {
        if (this.writer == null) {
            return this.queue.toString();
        }
        return this.writer.toString() + this.queue.toString();
    }

    public void append(ReadableByteChannel in) throws IOException {
        this.peek();
        this.queue.add(in);
    }

    public void print(CharSequence csq) throws IOException {
        if (this.writer == null) {
            this.out = new ByteArrayOutputStream(8192);
            this.writer = new OutputStreamWriter((OutputStream)this.out, Charset.forName("ISO-8859-1"));
        }
        if (csq != null) {
            this.writer.append(csq);
        }
    }

    public void println(CharSequence csq) throws IOException {
        this.print(csq);
        this.print("\r\n");
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        IOException ioe = null;
        RuntimeException re = null;
        Error er = null;
        for (ReadableByteChannel in : this.queue) {
            try {
                in.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            catch (RuntimeException e) {
                re = e;
            }
            catch (Error e) {
                er = e;
            }
        }
        if (er != null) {
            throw er;
        }
        if (re != null) {
            throw re;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        ReadableByteChannel in = this.peek();
        if (in == null) {
            return -1;
        }
        int read = in.read(dst);
        if (read < 0) {
            this.queue.remove().close();
            return this.read(dst);
        }
        return read;
    }

    private ReadableByteChannel peek() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.append(ChannelUtil.newChannel(this.out.toByteArray()));
        }
        return this.queue.peek();
    }
}

