/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class DocumentXMLEventReader
extends EventReaderDelegate {
    private final XMLEventFactory ef = XMLEventFactory.newInstance();
    private boolean started;
    private Object next;
    private boolean ended;

    public DocumentXMLEventReader(XMLEventReader reader) {
        super(reader);
    }

    @Override
    public void close() throws XMLStreamException {
        super.close();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.next != null) {
            try {
                if (this.next instanceof XMLEvent) {
                    XMLEvent xMLEvent = (XMLEvent)this.next;
                    return xMLEvent;
                }
            }
            finally {
                this.next = null;
            }
        }
        if (!this.started && !super.hasNext()) {
            this.started = true;
            return this.ef.createStartDocument();
        }
        if (!this.ended && !super.hasNext()) {
            this.ended = true;
            return this.ef.createEndDocument();
        }
        XMLEvent ret = super.nextEvent();
        if (ret != null && ret.isStartDocument()) {
            this.started = true;
        }
        if (ret != null && ret.isEndDocument()) {
            this.ended = true;
        }
        if (!this.started) {
            this.next = ret;
            this.started = true;
            return this.ef.createStartDocument();
        }
        return ret;
    }

    @Override
    public Object next() {
        if (this.next != null) {
            try {
                if (this.next instanceof XMLEvent) {
                    XMLEvent xMLEvent = (XMLEvent)this.next;
                    return xMLEvent;
                }
            }
            finally {
                this.next = null;
            }
        }
        if (!this.started && !super.hasNext()) {
            this.started = true;
            return this.ef.createStartDocument();
        }
        if (!this.ended && !super.hasNext()) {
            this.ended = true;
            return this.ef.createEndDocument();
        }
        Object ret = super.next();
        if (ret != null && ret instanceof StartDocument) {
            this.started = true;
        }
        if (ret != null && ret instanceof EndDocument) {
            this.ended = true;
        }
        if (!this.started) {
            this.next = ret;
            this.started = true;
            return this.ef.createStartDocument();
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        if (!this.ended) {
            return true;
        }
        return super.hasNext();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.next != null && this.next instanceof XMLEvent) {
            return (XMLEvent)this.next;
        }
        XMLEvent peek = super.peek();
        if (!this.started && !peek.isStartDocument()) {
            return this.ef.createStartDocument();
        }
        if (!this.ended && peek == null) {
            return this.ef.createEndDocument();
        }
        return peek;
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        if (!this.started) {
            this.started = true;
        }
        return super.nextTag();
    }
}

