/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.net.URI;
import java.net.URISyntaxException;

public class Relativizer {
    private final String baseURI;
    private final String authURI;
    private final String pathURI;
    private final String queryURI;
    private final String fragURI;
    private final String[] paths;

    public Relativizer(String baseURI) throws URISyntaxException {
        this.baseURI = baseURI;
        if (baseURI == null || URI.create(baseURI).isOpaque()) {
            this.authURI = null;
            this.pathURI = null;
            this.queryURI = null;
            this.fragURI = null;
            this.paths = new String[0];
        } else {
            URI parsed = URI.create(baseURI);
            this.paths = URI.create(baseURI).getPath().split("/", Integer.MAX_VALUE);
            String s = parsed.getScheme();
            String a = parsed.getAuthority();
            this.authURI = new URI(s, a, "/", null, null).toString();
            int path = baseURI.lastIndexOf(47);
            this.pathURI = baseURI.substring(0, path + 1);
            int query = baseURI.lastIndexOf(63);
            this.queryURI = query < 0 ? baseURI + "?" : baseURI.substring(0, query + 1);
            int frag = baseURI.lastIndexOf(35);
            this.fragURI = frag < 0 ? baseURI + "#" : baseURI.substring(0, frag + 1);
        }
    }

    public String relativize(String uri) {
        if (uri.equals(this.baseURI) && uri.indexOf(35) < 0) {
            return "";
        }
        if (this.pathURI == null) {
            return uri;
        }
        if (uri.startsWith(this.fragURI)) {
            return uri.substring(this.fragURI.length() - 1);
        }
        if (uri.startsWith(this.queryURI)) {
            return uri.substring(this.queryURI.length() - 1);
        }
        if (uri.equals(this.pathURI)) {
            return ".";
        }
        if (uri.startsWith(this.pathURI)) {
            return uri.substring(this.pathURI.length());
        }
        if (!uri.startsWith(this.authURI)) {
            return uri;
        }
        try {
            URI net = URI.create(uri);
            String path = this.relativizePath(net.getPath());
            URI ref = new URI(null, null, path, net.getQuery(), net.getFragment());
            return ref.toString();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String relativizePath(String path) {
        int i;
        int diff;
        assert (path.charAt(0) == '/');
        String[] seg = path.split("/", Integer.MAX_VALUE);
        for (diff = 1; diff < this.paths.length && diff < seg.length - 1 && this.paths[diff].equals(seg[diff]); ++diff) {
        }
        if (diff < 2) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        for (i = diff; i < this.paths.length - 1; ++i) {
            sb.append("../");
        }
        for (i = diff; i < seg.length - 1; ++i) {
            sb.append(seg[i]).append('/');
        }
        return sb.append(seg[seg.length - 1]).toString();
    }
}

