/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.LinkedList;
import org.openrdf.http.object.io.Relativizer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.turtle.TurtleUtil;
import org.openrdf.rio.turtle.TurtleWriter;

public class TurtleStreamWriter
extends TurtleWriter {
    private final Literal TRUE = ValueFactoryImpl.getInstance().createLiteral(true);
    private final Literal FALSE = ValueFactoryImpl.getInstance().createLiteral(false);
    private final Relativizer base;
    private final Deque<Resource> stack = new LinkedList<Resource>();

    public TurtleStreamWriter(OutputStream out, String systemId) throws URISyntaxException {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")), systemId);
    }

    public TurtleStreamWriter(Writer writer, String systemId) throws URISyntaxException {
        super(writer);
        this.writer.setIndentationString("    ");
        this.base = new Relativizer(systemId);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        try {
            Resource subj = st.getSubject();
            if (this.isHanging() && subj.equals(this.stack.peekLast())) {
                this.lastWrittenSubject = subj;
                this.writer.write("[");
                if (st.getPredicate().equals((Object)RDF.TYPE)) {
                    this.writer.write(" ");
                } else {
                    this.writer.writeEOL();
                }
                this.writer.increaseIndentation();
                this.writePredicate(st.getPredicate());
                this.writer.write(" ");
                this.lastWrittenPredicate = st.getPredicate();
                this.writeValue(st.getObject());
            } else if (!subj.equals(this.lastWrittenSubject) && this.stack.contains(subj)) {
                this.closeHangingResource();
                while (!subj.equals(this.stack.peekLast())) {
                    this.stack.pollLast();
                    this.writer.writeEOL();
                    this.writer.decreaseIndentation();
                    this.writer.write("]");
                    this.lastWrittenSubject = this.stack.peekLast();
                    this.lastWrittenPredicate = null;
                }
                super.handleStatement(st);
            } else {
                this.closeHangingResource();
                super.handleStatement(st);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void writeValue(Value obj) throws IOException {
        if (obj instanceof BNode && !obj.equals(this.stack.peekLast())) {
            this.stack.addLast((Resource)((BNode)obj));
        } else {
            super.writeValue(obj);
        }
    }

    protected void closePreviousStatement() throws IOException {
        this.closeHangingResource();
        while (this.stack.pollLast() != null) {
            this.writer.writeEOL();
            this.writer.decreaseIndentation();
            this.writer.write("]");
            this.lastWrittenSubject = this.stack.peekLast();
            this.lastWrittenPredicate = null;
        }
        super.closePreviousStatement();
    }

    private void closeHangingResource() throws IOException {
        if (this.isHanging()) {
            super.writeValue((Value)this.stack.pollLast());
        }
    }

    private boolean isHanging() {
        return !this.stack.isEmpty() && this.lastWrittenSubject != null && !this.lastWrittenSubject.equals(this.stack.peekLast());
    }

    protected void writeURI(URI uri) throws IOException {
        String uriString = uri.toString();
        String prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex((String)uriString);
        if (splitIdx > 0) {
            String namespace = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace);
        }
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(uriString.substring(splitIdx));
        } else {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString((String)this.base.relativize(uriString)));
            this.writer.write(">");
        }
    }

    protected void writeLiteral(Literal lit) throws IOException {
        if (lit.equals((Object)this.TRUE)) {
            this.writer.write("true");
        } else if (lit.equals((Object)this.FALSE)) {
            this.writer.write("false");
        } else if (XMLSchema.INTEGER.equals((Object)lit.getDatatype())) {
            this.writer.write(lit.getLabel());
        } else if (XMLSchema.DECIMAL.equals((Object)lit.getDatatype())) {
            this.writer.write(lit.getLabel());
        } else if (XMLSchema.DOUBLE.equals((Object)lit.getDatatype())) {
            this.writer.write(lit.getLabel());
        } else if (XMLSchema.STRING.equals((Object)lit.getDatatype())) {
            String label = lit.getLabel();
            if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
                this.writer.write("\"\"\"");
                this.writer.write(TurtleUtil.encodeLongString((String)label));
                this.writer.write("\"\"\"");
            } else {
                this.writer.write("\"");
                this.writer.write(TurtleUtil.encodeString((String)label));
                this.writer.write("\"");
            }
            if (lit.getLanguage() != null) {
                this.writer.write("@");
                this.writer.write(lit.getLanguage());
            }
        } else {
            super.writeLiteral(lit);
        }
    }
}

