/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventAllocator;
import org.openrdf.http.object.io.ClosingXMLEventReader;
import org.openrdf.http.object.io.DocumentXMLEventReader;

public class XMLEventReaderFactory {
    private XMLInputFactory factory;

    public static XMLEventReaderFactory newInstance() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isValidating", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            factory.setProperty("http://java.sun.com/xml/stream/properties/ignore-external-dtd", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new XMLEventReaderFactory(factory);
    }

    public XMLEventReaderFactory(XMLInputFactory factory) {
        this.factory = factory;
    }

    public XMLEventReader createXMLEventReader(InputStream stream, Charset charset) throws XMLStreamException {
        try {
            stream = this.checkForVoidXML(stream);
            if (stream == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return this.wrap(this.factory.createXMLEventReader(stream, charset.name()), stream);
    }

    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        try {
            stream = this.checkForVoidXML(stream);
            if (stream == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return this.wrap(this.factory.createXMLEventReader(stream), stream);
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        try {
            stream = this.checkForVoidXML(stream);
            if (stream == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return this.wrap(this.factory.createXMLEventReader(systemId, stream), stream);
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        try {
            reader = this.checkForVoidXML(reader);
            if (reader == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return this.wrap(this.factory.createXMLEventReader(reader), reader);
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        try {
            reader = this.checkForVoidXML(reader);
            if (reader == null) {
                return null;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        return this.wrap(this.factory.createXMLEventReader(systemId, reader), reader);
    }

    public XMLEventAllocator getEventAllocator() {
        return this.factory.getEventAllocator();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.factory.getProperty(name);
    }

    public XMLReporter getXMLReporter() {
        return this.factory.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.factory.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.factory.isPropertySupported(name);
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.factory.setEventAllocator(allocator);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        this.factory.setProperty(name, value);
    }

    public void setXMLReporter(XMLReporter reporter) {
        this.factory.setXMLReporter(reporter);
    }

    public void setXMLResolver(XMLResolver resolver) {
        this.factory.setXMLResolver(resolver);
    }

    private XMLEventReader wrap(XMLEventReader reader, Closeable io) {
        return new DocumentXMLEventReader(new ClosingXMLEventReader(reader, io));
    }

    private Reader checkForVoidXML(Reader reader) throws IOException {
        int read;
        if (reader == null) {
            return null;
        }
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        CharBuffer cbuf = CharBuffer.allocate(100);
        reader.mark(cbuf.limit());
        while (cbuf.hasRemaining() && (read = reader.read(cbuf)) >= 0) {
        }
        if (cbuf.hasRemaining() && this.isEmpty(cbuf.flip().toString())) {
            reader.close();
            return null;
        }
        reader.reset();
        return reader;
    }

    private InputStream checkForVoidXML(InputStream input) throws IOException {
        int read;
        if (input == null) {
            return null;
        }
        input = new BufferedInputStream(input);
        ByteBuffer buf = ByteBuffer.allocate(200);
        input.mark(buf.limit());
        while (buf.hasRemaining() && (read = input.read(buf.array(), buf.position(), buf.remaining())) >= 0) {
            buf.position(buf.position() + read);
        }
        if (buf.hasRemaining() && this.isEmpty(buf.array(), buf.position())) {
            input.close();
            return null;
        }
        input.reset();
        return input;
    }

    private boolean isEmpty(byte[] buf, int len) {
        if (len == 0) {
            return true;
        }
        String xml = this.decodeXML(buf, len);
        if (xml == null) {
            return false;
        }
        return this.isEmpty(xml);
    }

    private boolean isEmpty(String xml) {
        if (xml == null || xml.length() < 1 || xml.trim().length() < 1) {
            return true;
        }
        if (xml.length() < 2) {
            return false;
        }
        if (xml.charAt(0) != '<' || xml.charAt(1) != '?') {
            return false;
        }
        if (xml.charAt(xml.length() - 2) != '?' || xml.charAt(xml.length() - 1) != '>') {
            return false;
        }
        int n = xml.length() - 2;
        for (int i = 1; i < n; ++i) {
            if (xml.charAt(i) != '<') continue;
            return false;
        }
        return true;
    }

    private String decodeXML(byte[] buf, int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)buf[i]);
        }
        String s = sb.toString();
        String APPFcharset = null;
        int byteOrderMark = 0;
        if (s.startsWith("\u00fe\u00ff")) {
            APPFcharset = "UTF-16BE";
            byteOrderMark = 2;
        } else if (s.startsWith("\u00ff\u00fe")) {
            APPFcharset = "UTF-16LE";
            byteOrderMark = 2;
        } else if (s.startsWith("\u00ef\u00bb\u00bf")) {
            APPFcharset = "UTF-8";
            byteOrderMark = 3;
        } else if (s.startsWith("\u0000<")) {
            APPFcharset = "UTF-16BE";
        } else if (s.startsWith("<\u0000")) {
            APPFcharset = "UTF-16LE";
        } else if (s.startsWith("<")) {
            APPFcharset = "US-ASCII";
        } else if (s.startsWith("Lo\u00a7\u0094")) {
            APPFcharset = "CP037";
        } else {
            return null;
        }
        try {
            byte[] bytes = s.substring(byteOrderMark).getBytes("iso-8859-1");
            String xml = new String(bytes, APPFcharset);
            if (xml.startsWith("<")) {
                return xml;
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

