/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.zip.GZIPOutputStream;

public class FileHandler
extends StreamHandler {
    private static final String LCK_EXT = ".lck";
    private static final int DEFAULT_COUNT = 1;
    private static final int DEFAULT_LIMIT = 0;
    private static final boolean DEFAULT_GZIP = false;
    private static final boolean DEFAULT_APPEND = false;
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final Hashtable<String, FileLock> allLocks = new Hashtable();
    private int count;
    private int limit;
    private boolean gzip;
    private boolean append;
    private String pattern;
    private LogManager manager = LogManager.getLogManager();
    private MeasureOutputStream output;
    private File[] files;
    FileLock lock = null;
    String fileName = null;
    int uniqueID = -1;

    public FileHandler() throws IOException {
        this.manager.checkAccess();
        this.initProperties();
        this.initOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initOutputFiles() throws FileNotFoundException, IOException {
        while (true) {
            ++this.uniqueID;
            for (int generation = 0; generation < this.count; ++generation) {
                this.files[generation] = new File(this.parseFileName(generation));
            }
            this.fileName = this.files[0].getCanonicalPath();
            Hashtable<String, FileLock> hashtable = allLocks;
            synchronized (hashtable) {
                if (null != allLocks.get(this.fileName)) {
                    continue;
                }
                if (this.files[0].exists() && (!this.append || this.files[0].length() >= (long)this.limit)) {
                    for (int i = this.count - 1; i > 0; --i) {
                        if (this.files[i].exists()) {
                            this.files[i].delete();
                        }
                        this.renameTo(this.files[i - 1], this.files[i]);
                    }
                } else {
                    this.files[0].getParentFile().mkdirs();
                    this.setPermissions(this.files[0]);
                }
                FileOutputStream fileStream = new FileOutputStream(this.fileName + LCK_EXT);
                FileChannel channel = fileStream.getChannel();
                this.lock = channel.tryLock();
                if (null != this.lock) {
                    allLocks.put(this.fileName, this.lock);
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 7] lbl29 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName, this.append)), this.files[0].length());
                    this.setOutputStream(this.output);
                    return;
                }
                try {
                    fileStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void initProperties() {
        String className = this.getClass().getName();
        this.pattern = this.getStringProperty(className + ".pattern", DEFAULT_PATTERN);
        if (null == this.pattern || "".equals(this.pattern)) {
            throw new NullPointerException("Pattern cannot be empty");
        }
        this.gzip = this.getBooleanProperty(className + ".gzip", false);
        this.append = this.getBooleanProperty(className + ".append", false);
        this.count = this.getIntProperty(className + ".count", 1);
        this.limit = this.getIntProperty(className + ".limit", 0);
        this.count = this.count < 1 ? 1 : this.count;
        this.limit = this.limit < 0 ? 0 : this.limit;
        this.files = new File[this.count];
    }

    void findNextGeneration() {
        super.close();
        try {
            for (int i = this.count - 1; i > 0; --i) {
                if (this.files[i].exists()) {
                    this.files[i].delete();
                }
                this.renameTo(this.files[i - 1], this.files[i]);
            }
            this.setPermissions(this.files[0]);
            this.output = new MeasureOutputStream(new BufferedOutputStream(new FileOutputStream(this.files[0])));
        }
        catch (FileNotFoundException e1) {
            this.getErrorManager().error("Error happened when open log file.", e1, 4);
        }
        catch (IOException e1) {
            this.getErrorManager().error("Error while compressing log file.", e1, 2);
        }
        this.setOutputStream(this.output);
    }

    private void setPermissions(File file) throws IOException {
        file.createNewFile();
        file.setReadable(false, false);
        file.setReadable(true, true);
        file.setWritable(false, false);
        file.setWritable(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameTo(File file1, File file2) throws IOException {
        if (!file1.getName().endsWith(".gz") && file2.getName().endsWith(".gz")) {
            FileInputStream in = new FileInputStream(file1);
            try {
                OutputStream out = new FileOutputStream(file2);
                out = new GZIPOutputStream(out);
                try {
                    int read;
                    byte[] buf = new byte[1024];
                    while ((read = in.read(buf)) >= 0) {
                        out.write(buf, 0, read);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            file1.delete();
        } else {
            file1.renameTo(file2);
        }
    }

    private String parseFileName(int gen) {
        int cur = 0;
        int next = 0;
        boolean hasUniqueID = false;
        boolean hasGeneration = false;
        String tempPath = System.getProperty("java.io.tmpdir");
        boolean tempPathHasSepEnd = tempPath == null ? false : tempPath.endsWith(File.separator);
        String homePath = System.getProperty("user.home");
        boolean homePathHasSepEnd = homePath == null ? false : homePath.endsWith(File.separator);
        StringBuilder sb = new StringBuilder();
        this.pattern = this.pattern.replace('/', File.separatorChar);
        char[] value = this.pattern.toCharArray();
        while ((next = this.pattern.indexOf(37, cur)) >= 0) {
            if (++next >= this.pattern.length()) continue;
            switch (value[next]) {
                case 'g': {
                    sb.append(value, cur, next - cur - 1).append(gen);
                    hasGeneration = true;
                    break;
                }
                case 'u': {
                    sb.append(value, cur, next - cur - 1).append(this.uniqueID);
                    hasUniqueID = true;
                    break;
                }
                case 't': {
                    sb.append(value, cur, next - cur - 1).append(tempPath);
                    if (tempPathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case 'h': {
                    sb.append(value, cur, next - cur - 1).append(homePath);
                    if (homePathHasSepEnd) break;
                    sb.append(File.separator);
                    break;
                }
                case '%': {
                    sb.append(value, cur, next - cur - 1).append('%');
                    break;
                }
                default: {
                    sb.append(value, cur, next - cur);
                }
            }
            cur = ++next;
        }
        sb.append(value, cur, value.length - cur);
        if (!hasGeneration && this.count > 1) {
            sb.append(".").append(gen);
        }
        if (!hasUniqueID && this.uniqueID > 0) {
            sb.append(".").append(this.uniqueID);
        }
        if (this.gzip && gen > 0) {
            sb.append(".gz");
        }
        return sb.toString();
    }

    private boolean getBooleanProperty(String key, boolean defaultValue) {
        String property = this.manager.getProperty(key);
        if (null == property) {
            return defaultValue;
        }
        boolean result = defaultValue;
        if ("true".equalsIgnoreCase(property)) {
            result = true;
        } else if ("false".equalsIgnoreCase(property)) {
            result = false;
        }
        return result;
    }

    private String getStringProperty(String key, String defaultValue) {
        String property = this.manager.getProperty(key);
        return property == null ? defaultValue : property;
    }

    private int getIntProperty(String key, int defaultValue) {
        String property = this.manager.getProperty(key);
        int result = defaultValue;
        if (null != property) {
            try {
                result = Integer.parseInt(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        allLocks.remove(this.fileName);
        try {
            FileChannel channel = this.lock.channel();
            this.lock.release();
            channel.close();
            File file = new File(this.fileName + LCK_EXT);
            file.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.output.getLength() >= (long)this.limit) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    FileHandler.this.findNextGeneration();
                    return null;
                }
            });
        }
    }

    static class MeasureOutputStream
    extends OutputStream {
        OutputStream wrapped;
        long length;

        public MeasureOutputStream(OutputStream stream, long currentLength) {
            this.wrapped = stream;
            this.length = currentLength;
        }

        public MeasureOutputStream(OutputStream stream) {
            this(stream, 0L);
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.wrapped.write(oneByte);
            ++this.length;
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.wrapped.write(bytes);
            this.length += (long)bytes.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
            this.length += (long)len;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public void flush() throws IOException {
            this.wrapped.flush();
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long newLength) {
            this.length = newLength;
        }
    }
}

