/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.openrdf.http.object.Server;

public class LogMessageFormatter
extends Formatter {
    private static final long DAY_LENGTH = 86400000L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String newline = System.getProperty("line.separator");
    private long nextDateAt;
    private long minuteExpire;
    private String minute;

    public LogMessageFormatter() {
        this.advanceNextDate(System.currentTimeMillis());
    }

    @Override
    public String getHead(Handler h) {
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder(128);
        sb.append("#Software: ").append(Server.NAME).append(newline);
        this.appendDateString(sb.append("#Date: "), now).append(newline);
        return sb.toString();
    }

    @Override
    public String getTail(Handler h) {
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder(32);
        this.appendDateString(sb.append("#Date: "), now).append(newline);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        long now = record.getMillis();
        StringBuilder sb = new StringBuilder(256);
        String message = this.formatMessage(record);
        if (now >= this.nextDateAt) {
            LogMessageFormatter logMessageFormatter = this;
            synchronized (logMessageFormatter) {
                if (now >= this.nextDateAt) {
                    this.appendDateString(sb.append("#Date: "), now).append(newline);
                }
            }
        }
        sb.append(this.getTimeString(now)).append('\t');
        sb.append(message).append(newline);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private void advanceNextDate(long now) {
        long today = now / 86400000L * 86400000L;
        this.nextDateAt = today + 86400000L;
    }

    private StringBuilder appendDateString(StringBuilder sb, long now) {
        this.advanceNextDate(now);
        GregorianCalendar cal = new GregorianCalendar(UTC);
        cal.setTimeInMillis(now);
        sb.append(cal.get(1)).append('-');
        this.pad(sb, cal.get(2) + 1).append('-');
        this.pad(sb, cal.get(5)).append(' ');
        this.pad(sb, cal.get(11)).append(':');
        this.pad(sb, cal.get(12)).append(':');
        this.pad(sb, cal.get(13));
        return sb;
    }

    private Object getTimeString(long now) {
        if (now >= this.minuteExpire) {
            long m = now / 1000L / 60L;
            int hr = (int)(m / 60L % 24L);
            int min = (int)(m % 60L);
            StringBuilder sb = new StringBuilder(6);
            this.pad(this.pad(sb, hr).append(':'), min);
            this.minute = sb.toString();
            this.minuteExpire = (m + 1L) * 60L * 1000L;
        }
        return this.minute;
    }

    private StringBuilder pad(StringBuilder sb, int i) {
        if (i < 10) {
            sb.append('0');
        }
        return sb.append(i);
    }
}

